/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.configuration.ModelUtils;
import org.sonatype.nexus.configuration.model.CProps;

public class ModelloUtils {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    private ModelloUtils() {
    }

    public static Map<String, String> getMapFromConfigList(List<CProps> list) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)list.size());
        for (CProps props : list) {
            result.put(props.getKey(), props.getValue());
        }
        return result;
    }

    public static List<CProps> getConfigListFromMap(Map<String, String> map) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CProps cprop = new CProps();
            cprop.setKey(entry.getKey());
            cprop.setValue(entry.getValue());
            result.add(cprop);
        }
        return result;
    }

    public static <E> E load(String currentModelVersion, File file, ModelloModelReader<E> reader, ModelloModelUpgrader ... upgraders) throws ModelUtils.CorruptModelException, IOException {
        return ModelUtils.load(currentModelVersion, file, reader, upgraders);
    }

    public static <E> void save(E model, File file, ModelloModelWriter<E> writer) throws IOException {
        ModelUtils.save(model, file, writer);
    }

    public static abstract class ModelloModelUpgrader
    extends ModelUtils.CharacterModelUpgrader {
        private final Charset charset;

        protected ModelloModelUpgrader(String fromVersion, String toVersion) {
            this(fromVersion, toVersion, DEFAULT_CHARSET);
        }

        protected ModelloModelUpgrader(String fromVersion, String toVersion, Charset charset) {
            super(fromVersion, toVersion);
            this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
        }

        @Override
        public void upgrade(Reader reader, Writer writer) throws IOException, ModelUtils.CorruptModelException {
            try {
                this.doUpgrade(reader, writer);
            }
            catch (XmlPullParserException e) {
                throw new ModelUtils.CorruptModelException("Model corrupted" + e.getMessage(), e);
            }
        }

        public abstract void doUpgrade(Reader var1, Writer var2) throws IOException, XmlPullParserException;
    }

    public static abstract class ModelloModelWriter<E>
    extends ModelUtils.CharacterModelWriter<E> {
        protected ModelloModelWriter() {
            this(DEFAULT_CHARSET);
        }

        protected ModelloModelWriter(Charset charset) {
            super(charset);
        }
    }

    public static class VersionedInFieldXmlModelloModelHelper {
        private final Charset charset;
        private final String fieldName;

        public VersionedInFieldXmlModelloModelHelper(String fieldName) {
            this(DEFAULT_CHARSET, fieldName);
        }

        public VersionedInFieldXmlModelloModelHelper(Charset charset, String fieldName) {
            this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
            this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
        }

        public String readVersion(InputStream input) throws IOException, ModelUtils.CorruptModelException {
            Throwable throwable = null;
            try (InputStreamReader r = new InputStreamReader(input, this.charset);){
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)r);
                Xpp3Dom versionNode = dom.getChild(this.fieldName);
                if (versionNode != null) {
                    String originalFileVersion = versionNode.getValue();
                    if (Strings.isNullOrEmpty((String)originalFileVersion)) {
                        throw new ModelUtils.MissingModelVersionException("Passed in XML model have empty " + this.fieldName + " node");
                    }
                    String string = originalFileVersion;
                    return string;
                }
                try {
                    try {
                        throw new ModelUtils.MissingModelVersionException("Passed in XML model does not have " + this.fieldName + " node");
                    }
                    catch (XmlPullParserException e) {
                        throw new ModelUtils.CorruptModelException("Passed in XML model cannot be parsed", e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static abstract class ModelloModelReader<E>
    extends ModelUtils.CharacterModelReader<E> {
        protected ModelloModelReader() {
            this(DEFAULT_CHARSET);
        }

        protected ModelloModelReader(Charset charset) {
            super(charset);
        }

        @Override
        public E read(Reader reader) throws IOException, ModelUtils.CorruptModelException {
            try {
                return this.doRead(reader);
            }
            catch (XmlPullParserException e) {
                throw new ModelUtils.CorruptModelException("Model corrupted" + e.getMessage(), e);
            }
        }

        public abstract E doRead(Reader var1) throws IOException, XmlPullParserException;
    }
}

