/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractConfigurable;
import org.sonatype.nexus.configuration.Configurable;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class AbstractLastingConfigurable<C>
extends AbstractConfigurable<C>
implements Configurable<C> {
    private final String name;

    public AbstractLastingConfigurable(String name, EventBus eventBus, ApplicationConfiguration applicationConfiguration) {
        super(eventBus, applicationConfiguration);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        this.name = name;
    }

    @Inject
    public void init() {
        try {
            this.initializeConfiguration();
        }
        catch (ConfigurationException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }
}

