/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.Configurable;
import org.sonatype.nexus.configuration.ConfigurationCommitEvent;
import org.sonatype.nexus.configuration.ConfigurationPrepareForLoadEvent;
import org.sonatype.nexus.configuration.ConfigurationPrepareForSaveEvent;
import org.sonatype.nexus.configuration.ConfigurationRollbackEvent;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class AbstractConfigurable<C>
extends ComponentSupport
implements Configurable<C> {
    private EventBus eventBus;
    private ApplicationConfiguration applicationConfiguration;
    private CoreConfiguration<C> coreConfiguration;
    private boolean registeredWithEventBus;

    public AbstractConfigurable() {
    }

    public AbstractConfigurable(EventBus eventBus, ApplicationConfiguration applicationConfiguration) {
        this.setEventBus(eventBus);
        this.setApplicationConfiguration(applicationConfiguration);
        this.registerWithEventBus();
    }

    protected void setEventBus(EventBus eventBus) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
    }

    protected void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = (ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration);
    }

    protected boolean isConfigured() {
        return this.coreConfiguration != null && this.coreConfiguration.getConfiguration(false) != null;
    }

    protected void initializeConfiguration() throws ConfigurationException {
    }

    @Subscribe
    public final void onEvent(ConfigurationPrepareForLoadEvent evt) {
        try {
            this.initializeConfiguration();
        }
        catch (ConfigurationException e) {
            evt.putVeto((Object)this, e);
        }
    }

    @Subscribe
    public final void onEvent(ConfigurationPrepareForSaveEvent evt) {
        if (this.isDirty()) {
            try {
                this.prepareForSave();
                evt.getChanges().add(this);
            }
            catch (ConfigurationException e) {
                evt.putVeto((Object)this, e);
            }
        }
    }

    @Subscribe
    public final void onEvent(ConfigurationCommitEvent evt) {
        try {
            this.commitChanges();
        }
        catch (ConfigurationException e) {
            this.rollbackChanges();
        }
    }

    @Subscribe
    public final void onEvent(ConfigurationRollbackEvent evt) {
        this.rollbackChanges();
    }

    protected final ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public CoreConfiguration<C> getCurrentCoreConfiguration() {
        return this.coreConfiguration;
    }

    public final void configure(Object config) throws ConfigurationException {
        this.coreConfiguration = this.wrapConfiguration(config);
        this.getCurrentConfiguration(true);
        this.doConfigure();
    }

    public boolean isDirty() {
        CoreConfiguration<C> cc = this.getCurrentCoreConfiguration();
        return cc != null && cc.isDirty();
    }

    protected void prepareForSave() throws ConfigurationException {
        if (this.isDirty()) {
            this.getCurrentCoreConfiguration().validateChanges();
            if (this.getConfigurator() != null) {
                this.getConfigurator().prepareForSave(this, this.getApplicationConfiguration(), this.getCurrentCoreConfiguration());
            }
        }
    }

    public boolean commitChanges() throws ConfigurationException {
        if (this.isDirty()) {
            this.doConfigure();
            return true;
        }
        return false;
    }

    public boolean rollbackChanges() {
        if (this.isDirty()) {
            this.getCurrentCoreConfiguration().rollbackChanges();
            return true;
        }
        return false;
    }

    protected void doConfigure() throws ConfigurationException {
        this.getCurrentCoreConfiguration().validateChanges();
        if (this.getConfigurator() != null) {
            this.getConfigurator().applyConfiguration(this, this.getApplicationConfiguration(), this.getCurrentCoreConfiguration());
            this.getConfigurator().prepareForSave(this, this.getApplicationConfiguration(), this.getCurrentCoreConfiguration());
        }
        this.getCurrentCoreConfiguration().commitChanges();
    }

    protected EventBus eventBus() {
        return this.eventBus;
    }

    public void registerWithEventBus() {
        if (!this.registeredWithEventBus) {
            this.eventBus.register((Object)this);
            this.registeredWithEventBus = true;
        }
    }

    public void unregisterFromEventBus() {
        if (this.registeredWithEventBus) {
            this.eventBus.unregister((Object)this);
            this.registeredWithEventBus = false;
        }
    }

    protected Configurator getConfigurator() {
        return null;
    }

    public C getCurrentConfiguration(boolean forWrite) {
        return (C)this.getCurrentCoreConfiguration().getConfiguration(forWrite);
    }

    protected abstract CoreConfiguration<C> wrapConfiguration(Object var1) throws ConfigurationException;
}

