/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient.page;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.proxy.repository.ProxyRepository;

public class Page {
    private final HttpUriRequest httpUriRequest;
    private final HttpResponse httpResponse;
    private final Document document;
    private static final Logger LOG = LoggerFactory.getLogger(Page.class);

    private Page(HttpUriRequest httpUriRequest, HttpResponse httpResponse, Document document) {
        this.httpUriRequest = (HttpUriRequest)Preconditions.checkNotNull((Object)httpUriRequest);
        this.httpResponse = (HttpResponse)Preconditions.checkNotNull((Object)httpResponse);
        this.document = document;
    }

    public String getUrl() {
        return this.httpUriRequest.getURI().toString();
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean hasHeader(String headerName) {
        return this.getHttpResponse().getFirstHeader(headerName) != null;
    }

    public boolean hasHeaderAndStartsWith(String headerName, String value) {
        Header header = this.getHttpResponse().getFirstHeader(headerName);
        return header != null && header.getValue() != null && header.getValue().startsWith(value);
    }

    public boolean hasHeaderAndEqualsWith(String headerName, String value) {
        Header header = this.getHttpResponse().getFirstHeader(headerName);
        return header != null && header.getValue() != null && header.getValue().equals(value);
    }

    public static Page getPageFor(PageContext context, String url) throws IOException {
        return Page.buildPageFor(context, (HttpUriRequest)new HttpGet(url));
    }

    public static Page buildPageFor(PageContext context, HttpUriRequest httpUriRequest) throws IOException {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)httpUriRequest);
        LOG.debug("Executing HTTP {} request against {}", (Object)httpUriRequest.getMethod(), (Object)httpUriRequest.getURI());
        HttpResponse response = context.executeHttpRequest(httpUriRequest);
        try {
            if (context.isExpectedResponse(response)) {
                if (response.getEntity() != null) {
                    Page page = new Page(httpUriRequest, response, Jsoup.parse((InputStream)response.getEntity().getContent(), null, (String)httpUriRequest.getURI().toString()));
                    return page;
                }
                Page page = new Page(httpUriRequest, response, null);
                return page;
            }
            throw new UnexpectedPageResponse(httpUriRequest.getURI().toString(), response.getStatusLine());
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public static class UnexpectedPageResponse
    extends IOException {
        private final String url;
        private final StatusLine statusLine;

        public UnexpectedPageResponse(String url, StatusLine statusLine) {
            super("Unexpected response from remote repository URL " + url + " : " + statusLine);
            this.url = url;
            this.statusLine = statusLine;
        }

        public String getUrl() {
            return this.url;
        }

        public StatusLine getStatusLine() {
            return this.statusLine;
        }
    }

    public static class RepositoryPageContext
    extends PageContext {
        private final ProxyRepository proxyRepository;

        public RepositoryPageContext(HttpClient httpClient, ProxyRepository proxyRepository) {
            super(httpClient);
            this.proxyRepository = (ProxyRepository)Preconditions.checkNotNull((Object)proxyRepository);
        }

        protected ProxyRepository getProxyRepository() {
            return this.proxyRepository;
        }

        @Override
        public HttpContext createHttpContext(HttpUriRequest httpRequest) throws IOException {
            HttpContext httpContext = super.createHttpContext(httpRequest);
            httpContext.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)this.getProxyRepository());
            return httpContext;
        }
    }

    public static class PageContext {
        private final HttpClient httpClient;

        public PageContext(HttpClient httpClient) {
            this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient);
        }

        protected HttpClient getHttpClient() {
            return this.httpClient;
        }

        public HttpContext createHttpContext(HttpUriRequest httpRequest) throws IOException {
            return new BasicHttpContext();
        }

        public HttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws IOException {
            HttpContext httpContext = this.createHttpContext(httpRequest);
            return this.getHttpClient().execute(httpRequest, httpContext);
        }

        public boolean isExpectedResponse(HttpResponse response) {
            return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() <= 499;
        }
    }
}

