/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import java.lang.management.ManagementFactory;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.apachehttpclient.PoolingClientConnectionManagerMBeanImpl;

@Named
@Singleton
public class PoolingClientConnectionManagerMBeanInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingClientConnectionManagerMBeanInstaller.class);
    private static final String JMX_DOMAIN = "org.sonatype.nexus.httpclient";
    private ObjectName jmxName;

    public synchronized void register(PoolingHttpClientConnectionManager connectionManager) {
        if (this.jmxName == null) {
            try {
                this.jmxName = ObjectName.getInstance(JMX_DOMAIN, "name", PoolingHttpClientConnectionManager.class.getSimpleName());
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                server.registerMBean(new PoolingClientConnectionManagerMBeanImpl(connectionManager), this.jmxName);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to register mbean {} due to {}:{}", new Object[]{this.jmxName, e.getClass(), e.getMessage()});
                this.jmxName = null;
            }
        } else {
            LOGGER.warn("Already registered mbean {}", (Object)this.jmxName);
        }
    }

    public synchronized void unregister() {
        if (this.jmxName != null) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                server.unregisterMBean(this.jmxName);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to unregister mbean {} due to {}:{}", new Object[]{this.jmxName, e.getClass(), e.getMessage()});
            }
            finally {
                this.jmxName = null;
            }
        }
    }
}

