/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.management.StandardMBean;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.sonatype.nexus.apachehttpclient.PoolingClientConnectionManagerMBean;

class PoolingClientConnectionManagerMBeanImpl
extends StandardMBean
implements PoolingClientConnectionManagerMBean {
    private final PoolingHttpClientConnectionManager connMgr;

    PoolingClientConnectionManagerMBeanImpl(PoolingHttpClientConnectionManager connMgr) {
        super(PoolingClientConnectionManagerMBean.class, false);
        this.connMgr = (PoolingHttpClientConnectionManager)Preconditions.checkNotNull((Object)connMgr);
    }

    @Override
    public int getMaxTotal() {
        return this.connMgr.getMaxTotal();
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.connMgr.getDefaultMaxPerRoute();
    }

    @Override
    public int getLeased() {
        return this.connMgr.getTotalStats().getLeased();
    }

    @Override
    public int getPending() {
        return this.connMgr.getTotalStats().getPending();
    }

    @Override
    public int getAvailable() {
        return this.connMgr.getTotalStats().getAvailable();
    }

    @Override
    public int getMax() {
        return this.connMgr.getTotalStats().getMax();
    }

    @Override
    public void closeIdleConnections(long idleTimeoutInMillis) {
        this.connMgr.closeIdleConnections(idleTimeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void closeExpiredConnections() {
        this.connMgr.closeExpiredConnections();
    }

    @Override
    public void setMaxTotal(int max) {
        this.connMgr.setMaxTotal(max);
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.connMgr.setDefaultMaxPerRoute(max);
    }
}

