/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.sonatype.nexus.apachehttpclient.SSLContextSelector;
import sun.security.ssl.SSLSocketImpl;

public class NexusSSLConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    private static final Splitter propertiesSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final SSLSocketFactory defaultSocketFactory;
    private final List<SSLContextSelector> selectors;
    private final X509HostnameVerifier hostnameVerifier;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public NexusSSLConnectionSocketFactory(SSLSocketFactory defaultSocketFactory, X509HostnameVerifier hostnameVerifier, List<SSLContextSelector> selectors) {
        this.defaultSocketFactory = (SSLSocketFactory)Preconditions.checkNotNull((Object)defaultSocketFactory);
        this.hostnameVerifier = (X509HostnameVerifier)Preconditions.checkNotNull((Object)hostnameVerifier);
        this.selectors = selectors;
        this.supportedProtocols = NexusSSLConnectionSocketFactory.split(System.getProperty("https.protocols"));
        this.supportedCipherSuites = NexusSSLConnectionSocketFactory.split(System.getProperty("https.cipherSuites"));
    }

    private SSLSocketFactory select(HttpContext context) {
        if (this.selectors != null) {
            for (SSLContextSelector selector : this.selectors) {
                SSLContext sslContext = selector.select(context);
                if (sslContext == null) continue;
                return sslContext.getSocketFactory();
            }
        }
        return this.defaultSocketFactory;
    }

    private void verifyHostname(SSLSocket sslsock, String hostname) throws IOException {
        try {
            this.hostnameVerifier.verify(hostname, sslsock);
        }
        catch (IOException e) {
            Closeables.close((Closeable)sslsock, (boolean)true);
            throw e;
        }
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return this.configure((SSLSocket)this.select(context).createSocket());
    }

    @IgnoreJRERequirement
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sock;
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)remoteAddress);
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        if (sock instanceof SSLSocketImpl) {
            ((SSLSocketImpl)sock).setHost(host.getHostName());
        }
        try {
            if (connectTimeout > 0 && sock.getSoTimeout() == 0) {
                sock.setSoTimeout(connectTimeout);
            }
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (IOException e) {
            Closeables.close((Closeable)sock, (boolean)true);
            throw e;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslsock = (SSLSocket)sock;
            sslsock.startHandshake();
            this.verifyHostname(sslsock, host.getHostName());
            return sock;
        }
        return this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        Preconditions.checkNotNull((Object)socket);
        Preconditions.checkNotNull((Object)target);
        SSLSocket sslsock = this.configure((SSLSocket)this.select(context).createSocket(socket, target, port, true));
        sslsock.startHandshake();
        this.verifyHostname(sslsock, target);
        return sslsock;
    }

    private SSLSocket configure(SSLSocket socket) {
        if (this.supportedProtocols != null) {
            socket.setEnabledProtocols(this.supportedProtocols);
        } else {
            String[] allProtocols = socket.getSupportedProtocols();
            ArrayList<String> enabledProtocols = new ArrayList<String>(allProtocols.length);
            for (String protocol : allProtocols) {
                if (protocol.startsWith("SSL")) continue;
                enabledProtocols.add(protocol);
            }
            socket.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
        }
        if (this.supportedCipherSuites != null) {
            socket.setEnabledCipherSuites(this.supportedCipherSuites);
        }
        return socket;
    }

    private static String[] split(String s) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return (String[])Iterables.toArray((Iterable)propertiesSplitter.split((CharSequence)s), String.class);
    }
}

