/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

class NexusHttpRoutePlanner
extends DefaultRoutePlanner {
    private final Set<Pattern> nonProxyHostPatterns;
    private final Map<String, HttpHost> proxies;

    NexusHttpRoutePlanner(Map<String, HttpHost> proxies, Set<Pattern> nonProxyHostPatterns, SchemePortResolver schemePortResolver) {
        super(schemePortResolver);
        this.proxies = (Map)Preconditions.checkNotNull(proxies);
        this.nonProxyHostPatterns = (Set)Preconditions.checkNotNull(nonProxyHostPatterns);
    }

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return super.determineRoute(target, request, context);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (this.noProxyFor(target.getHostName())) {
            return null;
        }
        return this.proxies.get(target.getSchemeName());
    }

    private boolean noProxyFor(String hostName) {
        for (Pattern nonProxyHostPattern : this.nonProxyHostPatterns) {
            if (!nonProxyHostPattern.matcher(hostName).matches()) continue;
            return true;
        }
        return false;
    }
}

