/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.protocol.HttpContext;

public class NexusConnectionKeepAliveStrategy
extends DefaultConnectionKeepAliveStrategy {
    private final long maxKeepAliveDuration;

    public NexusConnectionKeepAliveStrategy(long maxKeepAliveDuration) {
        Preconditions.checkArgument((maxKeepAliveDuration > -1L ? 1 : 0) != 0, (String)"maxKeepAliveDuration must be 0 or higher, but is set to %s", (Object[])new Object[]{maxKeepAliveDuration});
        this.maxKeepAliveDuration = maxKeepAliveDuration;
    }

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        long result = super.getKeepAliveDuration(response, context);
        if (result < 0L) {
            return this.maxKeepAliveDuration;
        }
        return Math.min(result, this.maxKeepAliveDuration);
    }
}

