/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.sonatype.nexus.apachehttpclient.EvictingThread;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.apachehttpclient.Hc4ProviderBase;
import org.sonatype.nexus.apachehttpclient.NexusSSLConnectionSocketFactory;
import org.sonatype.nexus.apachehttpclient.PoolingClientConnectionManagerMBeanInstaller;
import org.sonatype.nexus.apachehttpclient.SSLContextSelector;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.utils.UserAgentBuilder;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class Hc4ProviderImpl
extends Hc4ProviderBase
implements Hc4Provider {
    private static final String CONNECTION_POOL_MAX_SIZE_KEY = "nexus.apacheHttpClient4x.connectionPoolMaxSize";
    private static final int CONNECTION_POOL_MAX_SIZE_DEFAULT = 200;
    private static final String CONNECTION_POOL_SIZE_KEY = "nexus.apacheHttpClient4x.connectionPoolSize";
    private static final int CONNECTION_POOL_SIZE_DEFAULT = 20;
    private static final String CONNECTION_POOL_IDLE_TIME_KEY = "nexus.apacheHttpClient4x.connectionPoolIdleTime";
    private static final long CONNECTION_POOL_IDLE_TIME_DEFAULT = TimeUnit.SECONDS.toMillis(30L);
    private static final String CONNECTION_POOL_TIMEOUT_KEY = "nexus.apacheHttpClient4x.connectionPoolTimeout";
    private static final long CONNECTION_POOL_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(30L);
    private final ApplicationConfiguration applicationConfiguration;
    private final EventBus eventBus;
    private final ManagedClientConnectionManager sharedConnectionManager;
    private final EvictingThread evictingThread;
    private final PoolingClientConnectionManagerMBeanInstaller jmxInstaller;

    @Inject
    public Hc4ProviderImpl(ApplicationConfiguration applicationConfiguration, UserAgentBuilder userAgentBuilder, EventBus eventBus, PoolingClientConnectionManagerMBeanInstaller jmxInstaller, List<SSLContextSelector> selectors) {
        super(userAgentBuilder);
        this.applicationConfiguration = (ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration);
        this.jmxInstaller = (PoolingClientConnectionManagerMBeanInstaller)Preconditions.checkNotNull((Object)jmxInstaller);
        this.sharedConnectionManager = this.createClientConnectionManager(selectors);
        this.evictingThread = new EvictingThread((HttpClientConnectionManager)this.sharedConnectionManager, this.getConnectionPoolIdleTime());
        this.evictingThread.start();
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.eventBus.register((Object)this);
        this.jmxInstaller.register(this.sharedConnectionManager);
        this.log.info("Started (connectionPoolMaxSize {}, connectionPoolSize {}, connectionPoolIdleTime {} ms, connectionPoolTimeout {} ms, keepAliveMaxDuration {} ms)", new Object[]{this.getConnectionPoolMaxSize(), this.getConnectionPoolSize(), this.getConnectionPoolIdleTime(), this.getConnectionPoolTimeout(), this.getKeepAliveMaxDuration()});
    }

    protected int getConnectionPoolMaxSize() {
        return SystemPropertiesHelper.getInteger(CONNECTION_POOL_MAX_SIZE_KEY, 200);
    }

    protected int getConnectionPoolSize() {
        return SystemPropertiesHelper.getInteger(CONNECTION_POOL_SIZE_KEY, 20);
    }

    protected long getConnectionPoolIdleTime() {
        return SystemPropertiesHelper.getLong(CONNECTION_POOL_IDLE_TIME_KEY, CONNECTION_POOL_IDLE_TIME_DEFAULT);
    }

    protected long getConnectionPoolTimeout() {
        return SystemPropertiesHelper.getLong(CONNECTION_POOL_TIMEOUT_KEY, CONNECTION_POOL_TIMEOUT_DEFAULT);
    }

    public synchronized void shutdown() {
        this.evictingThread.interrupt();
        this.jmxInstaller.unregister();
        this.sharedConnectionManager._shutdown();
        this.eventBus.unregister((Object)this);
        this.log.info("Stopped");
    }

    @Subscribe
    public void onEvent(NexusStoppedEvent evt) {
        this.shutdown();
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public HttpClient createHttpClient() {
        return this.createHttpClient(this.reuseConnectionsNeeded(this.applicationConfiguration.getGlobalRemoteStorageContext()));
    }

    @Override
    public HttpClient createHttpClient(boolean reuseConnections) {
        Hc4Provider.Builder builder = this.prepareHttpClient(this.applicationConfiguration.getGlobalRemoteStorageContext());
        if (!reuseConnections) {
            builder.getHttpClientBuilder().setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        }
        return builder.build();
    }

    @Override
    public HttpClient createHttpClient(RemoteStorageContext context) {
        return this.prepareHttpClient(context).build();
    }

    @Override
    public Hc4Provider.Builder prepareHttpClient(RemoteStorageContext context) {
        return this.prepareHttpClient(context, (HttpClientConnectionManager)this.sharedConnectionManager);
    }

    @Override
    protected void applyConfig(Hc4Provider.Builder builder, RemoteStorageContext context) {
        super.applyConfig(builder, context);
        builder.getRequestConfigBuilder().setConnectionRequestTimeout(Ints.checkedCast((long)this.getConnectionPoolTimeout()));
    }

    protected ManagedClientConnectionManager createClientConnectionManager(List<SSLContextSelector> selectors) throws IllegalStateException {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new NexusSSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER, selectors)).build();
        ManagedClientConnectionManager connManager = new ManagedClientConnectionManager((Registry<ConnectionSocketFactory>)registry);
        int maxConnectionCount = this.getConnectionPoolMaxSize();
        int perRouteConnectionCount = Math.min(this.getConnectionPoolSize(), maxConnectionCount);
        connManager.setMaxTotal(maxConnectionCount);
        connManager.setDefaultMaxPerRoute(perRouteConnectionCount);
        return connManager;
    }

    private class ManagedClientConnectionManager
    extends PoolingHttpClientConnectionManager {
        public ManagedClientConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
            super(schemeRegistry);
        }

        public void shutdown() {
        }

        private void _shutdown() {
            super.shutdown();
        }
    }
}

