/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.apachehttpclient.NexusConnectionKeepAliveStrategy;
import org.sonatype.nexus.apachehttpclient.NexusHttpRoutePlanner;
import org.sonatype.nexus.proxy.repository.ClientSSLRemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.NtlmRemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.RemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.RemoteProxySettings;
import org.sonatype.nexus.proxy.repository.UsernamePasswordRemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.utils.UserAgentBuilder;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class Hc4ProviderBase
extends ComponentSupport {
    private static final String KEEP_ALIVE_MAX_DURATION_KEY = "nexus.apacheHttpClient4x.keepAliveMaxDuration";
    private static final long KEEP_ALIVE_MAX_DURATION_DEFAULT = TimeUnit.SECONDS.toMillis(30L);
    private final UserAgentBuilder userAgentBuilder;

    public Hc4ProviderBase(UserAgentBuilder userAgentBuilder) {
        this.userAgentBuilder = (UserAgentBuilder)Preconditions.checkNotNull((Object)userAgentBuilder);
    }

    protected Hc4Provider.Builder prepareHttpClient(RemoteStorageContext context, HttpClientConnectionManager httpClientConnectionManager) {
        Hc4Provider.Builder builder = new Hc4Provider.Builder();
        builder.getHttpClientBuilder().setConnectionManager(httpClientConnectionManager);
        builder.getHttpClientBuilder().addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding());
        this.applyConfig(builder, context);
        this.applyAuthenticationConfig(builder, context.getRemoteAuthenticationSettings(), null);
        this.applyProxyConfig(builder, context.getRemoteProxySettings());
        int retries = context.getRemoteConnectionSettings() != null ? context.getRemoteConnectionSettings().getRetrievalRetryCount() : 0;
        builder.getHttpClientBuilder().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(retries, false));
        builder.getHttpClientBuilder().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new NexusConnectionKeepAliveStrategy(this.getKeepAliveMaxDuration()));
        return builder;
    }

    protected void applyConfig(Hc4Provider.Builder builder, RemoteStorageContext context) {
        builder.getSocketConfigBuilder().setSoTimeout(this.getSoTimeout(context));
        builder.getConnectionConfigBuilder().setBufferSize(8192);
        builder.getRequestConfigBuilder().setCookieSpec("ignoreCookies");
        builder.getRequestConfigBuilder().setExpectContinueEnabled(false);
        builder.getRequestConfigBuilder().setStaleConnectionCheckEnabled(false);
        builder.getRequestConfigBuilder().setConnectTimeout(this.getConnectionTimeout(context));
        builder.getRequestConfigBuilder().setSocketTimeout(this.getSoTimeout(context));
        final String userAgent = this.userAgentBuilder.formatUserAgentString(context);
        builder.getHttpClientBuilder().setUserAgent(userAgent);
        builder.getHttpClientBuilder().setRequestExecutor(new HttpRequestExecutor(){

            public void preProcess(HttpRequest request, HttpProcessor processor, HttpContext ctx) throws HttpException, IOException {
                if (!request.containsHeader("User-Agent")) {
                    request.addHeader((Header)new BasicHeader("User-Agent", userAgent));
                }
                super.preProcess(request, processor, ctx);
            }
        });
    }

    protected long getKeepAliveMaxDuration() {
        return SystemPropertiesHelper.getLong(KEEP_ALIVE_MAX_DURATION_KEY, KEEP_ALIVE_MAX_DURATION_DEFAULT);
    }

    protected int getConnectionTimeout(RemoteStorageContext context) {
        if (context.getRemoteConnectionSettings() != null) {
            return context.getRemoteConnectionSettings().getConnectionTimeout();
        }
        return 1000;
    }

    protected int getSoTimeout(RemoteStorageContext context) {
        return this.getConnectionTimeout(context);
    }

    protected boolean reuseConnectionsNeeded(RemoteStorageContext context) {
        if (context != null) {
            if (context.getRemoteAuthenticationSettings() instanceof NtlmRemoteAuthenticationSettings) {
                return true;
            }
            if (context.getRemoteProxySettings() != null) {
                if (context.getRemoteProxySettings().getHttpProxySettings() != null && context.getRemoteProxySettings().getHttpProxySettings().getProxyAuthentication() instanceof NtlmRemoteAuthenticationSettings) {
                    return true;
                }
                if (context.getRemoteProxySettings().getHttpsProxySettings() != null && context.getRemoteProxySettings().getHttpsProxySettings().getProxyAuthentication() instanceof NtlmRemoteAuthenticationSettings) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void applyAuthenticationConfig(Hc4Provider.Builder builder, RemoteAuthenticationSettings ras, HttpHost proxyHost) {
        if (ras != null) {
            String authScope = "target";
            if (proxyHost != null) {
                authScope = proxyHost.toHostString() + " proxy";
            }
            ArrayList authorisationPreference = Lists.newArrayListWithExpectedSize((int)3);
            authorisationPreference.add("Digest");
            authorisationPreference.add("Basic");
            UsernamePasswordCredentials credentials = null;
            if (ras instanceof ClientSSLRemoteAuthenticationSettings) {
                throw new IllegalArgumentException("SSL client authentication not yet supported!");
            }
            if (ras instanceof NtlmRemoteAuthenticationSettings) {
                NtlmRemoteAuthenticationSettings nras = (NtlmRemoteAuthenticationSettings)ras;
                authorisationPreference.add(0, "NTLM");
                this.log.debug("{} authentication setup for NTLM domain '{}'", (Object)authScope, (Object)nras.getNtlmDomain());
                credentials = new NTCredentials(nras.getUsername(), nras.getPassword(), nras.getNtlmHost(), nras.getNtlmDomain());
            } else if (ras instanceof UsernamePasswordRemoteAuthenticationSettings) {
                UsernamePasswordRemoteAuthenticationSettings uras = (UsernamePasswordRemoteAuthenticationSettings)ras;
                this.log.debug("{} authentication setup for remote storage with username '{}'", (Object)authScope, (Object)uras.getUsername());
                credentials = new UsernamePasswordCredentials(uras.getUsername(), uras.getPassword());
            }
            if (credentials != null) {
                if (proxyHost != null) {
                    builder.setCredentials(new AuthScope(proxyHost), (Credentials)credentials);
                    builder.getRequestConfigBuilder().setProxyPreferredAuthSchemes((Collection)authorisationPreference);
                } else {
                    builder.setCredentials(AuthScope.ANY, (Credentials)credentials);
                    builder.getRequestConfigBuilder().setTargetPreferredAuthSchemes((Collection)authorisationPreference);
                }
            }
        }
    }

    protected void applyProxyConfig(Hc4Provider.Builder builder, RemoteProxySettings remoteProxySettings) {
        if (remoteProxySettings != null && remoteProxySettings.getHttpProxySettings() != null && remoteProxySettings.getHttpProxySettings().isEnabled()) {
            HashMap proxies = Maps.newHashMap();
            HttpHost httpProxy = new HttpHost(remoteProxySettings.getHttpProxySettings().getHostname(), remoteProxySettings.getHttpProxySettings().getPort());
            this.applyAuthenticationConfig(builder, remoteProxySettings.getHttpProxySettings().getProxyAuthentication(), httpProxy);
            this.log.debug("http proxy setup with host '{}'", (Object)remoteProxySettings.getHttpProxySettings().getHostname());
            proxies.put("http", httpProxy);
            proxies.put("https", httpProxy);
            if (remoteProxySettings.getHttpsProxySettings() != null && remoteProxySettings.getHttpsProxySettings().isEnabled()) {
                HttpHost httpsProxy = new HttpHost(remoteProxySettings.getHttpsProxySettings().getHostname(), remoteProxySettings.getHttpsProxySettings().getPort());
                this.applyAuthenticationConfig(builder, remoteProxySettings.getHttpsProxySettings().getProxyAuthentication(), httpsProxy);
                this.log.debug("https proxy setup with host '{}'", (Object)remoteProxySettings.getHttpsProxySettings().getHostname());
                proxies.put("https", httpsProxy);
            }
            HashSet nonProxyHostPatterns = Sets.newHashSet();
            if (remoteProxySettings.getNonProxyHosts() != null && !remoteProxySettings.getNonProxyHosts().isEmpty()) {
                for (String nonProxyHostRegex : remoteProxySettings.getNonProxyHosts()) {
                    try {
                        nonProxyHostPatterns.add(Pattern.compile(nonProxyHostRegex, 2));
                    }
                    catch (PatternSyntaxException e) {
                        this.log.warn("Invalid non proxy host regex: {}", (Object)nonProxyHostRegex, (Object)e);
                    }
                }
            }
            builder.getHttpClientBuilder().setRoutePlanner((HttpRoutePlanner)new NexusHttpRoutePlanner(proxies, nonProxyHostPatterns, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE));
        }
    }
}

