/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;

public interface Hc4Provider {
    public static final String HTTP_CTX_KEY_REPOSITORY = Hc4Provider.class.getName() + ".repository";

    public HttpClient createHttpClient();

    public HttpClient createHttpClient(boolean var1);

    public HttpClient createHttpClient(RemoteStorageContext var1);

    public Builder prepareHttpClient(RemoteStorageContext var1);

    public static class Builder {
        private final HttpClientBuilder httpClientBuilder;
        private final ConnectionConfig.Builder connectionConfigBuilder;
        private final SocketConfig.Builder socketConfigBuilder;
        private final RequestConfig.Builder requestConfigBuilder;
        private final CredentialsProvider credentialsProvider;
        private boolean credentialsProviderAltered;

        Builder() {
            this(HttpClientBuilder.create(), ConnectionConfig.copy((ConnectionConfig)ConnectionConfig.DEFAULT), SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT), RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT));
        }

        Builder(HttpClientBuilder httpClientBuilder, ConnectionConfig.Builder connectionConfigBuilder, SocketConfig.Builder socketConfigBuilder, RequestConfig.Builder requestConfigBuilder) {
            this.httpClientBuilder = (HttpClientBuilder)Preconditions.checkNotNull((Object)httpClientBuilder);
            this.connectionConfigBuilder = (ConnectionConfig.Builder)Preconditions.checkNotNull((Object)connectionConfigBuilder);
            this.socketConfigBuilder = (SocketConfig.Builder)Preconditions.checkNotNull((Object)socketConfigBuilder);
            this.requestConfigBuilder = (RequestConfig.Builder)Preconditions.checkNotNull((Object)requestConfigBuilder);
            this.credentialsProvider = new BasicCredentialsProvider();
            this.credentialsProviderAltered = false;
        }

        public HttpClientBuilder getHttpClientBuilder() {
            return this.httpClientBuilder;
        }

        public Builder setCredentials(AuthScope authscope, Credentials credentials) {
            Preconditions.checkNotNull((Object)authscope);
            this.credentialsProvider.setCredentials(authscope, credentials);
            this.credentialsProviderAltered = true;
            return this;
        }

        @VisibleForTesting
        CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public ConnectionConfig.Builder getConnectionConfigBuilder() {
            return this.connectionConfigBuilder;
        }

        public SocketConfig.Builder getSocketConfigBuilder() {
            return this.socketConfigBuilder;
        }

        public RequestConfig.Builder getRequestConfigBuilder() {
            return this.requestConfigBuilder;
        }

        public HttpClient build() {
            this.httpClientBuilder.setDefaultConnectionConfig(this.connectionConfigBuilder.build());
            this.httpClientBuilder.setDefaultSocketConfig(this.socketConfigBuilder.build());
            this.httpClientBuilder.setDefaultRequestConfig(this.requestConfigBuilder.build());
            if (this.credentialsProviderAltered) {
                this.httpClientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
            }
            return this.httpClientBuilder.build();
        }
    }
}

