/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.apachehttpclient;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EvictingThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvictingThread.class);
    private final HttpClientConnectionManager httpClientConnectionManager;
    private final long idleTimeMillis;
    private final long delay;

    EvictingThread(HttpClientConnectionManager httpClientConnectionManager, long idleTimeMillis, long delay) {
        super("HC4x-EvictingThread");
        Preconditions.checkArgument((idleTimeMillis > -1L ? 1 : 0) != 0, (Object)"Keep alive period in milliseconds cannot be negative");
        this.httpClientConnectionManager = (HttpClientConnectionManager)Preconditions.checkNotNull((Object)httpClientConnectionManager);
        this.idleTimeMillis = idleTimeMillis;
        this.delay = delay;
        this.setDaemon(true);
        this.setPriority(1);
    }

    EvictingThread(HttpClientConnectionManager httpClientConnectionManager, long idleTimeMillis) {
        this(httpClientConnectionManager, idleTimeMillis, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOGGER.debug("Starting '{}' (delay {} millis)", (Object)this.getName(), (Object)this.delay);
        try {
            while (true) {
                EvictingThread evictingThread = this;
                synchronized (evictingThread) {
                    this.wait(this.delay);
                    try {
                        this.httpClientConnectionManager.closeExpiredConnections();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to close expired connections", (Throwable)e);
                    }
                    try {
                        this.httpClientConnectionManager.closeIdleConnections(this.idleTimeMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to close expired connections", (Throwable)e);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.debug("Stopped '{}'", (Object)this.getName());
            return;
        }
    }
}

