/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemState;
import org.sonatype.nexus.configuration.ConfigurationChangeEvent;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.events.EventSubscriberHost;
import org.sonatype.nexus.plugins.NexusPluginManager;
import org.sonatype.nexus.plugins.PluginManagerResponse;
import org.sonatype.nexus.proxy.events.NexusInitializedEvent;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppingEvent;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.tasks.SynchronizeShadowsTask;
import org.sonatype.security.SecuritySystem;
import org.sonatype.sisu.goodies.eventbus.EventBus;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Singleton
@Named
public class NxApplication
extends LifecycleSupport {
    private final EventBus eventBus;
    private final ApplicationStatusSource applicationStatusSource;
    private final NexusConfiguration nexusConfiguration;
    private final NexusPluginManager nexusPluginManager;
    private final SecuritySystem securitySystem;
    private final NexusScheduler nexusScheduler;
    private final RepositoryRegistry repositoryRegistry;
    private final EventSubscriberHost eventSubscriberHost;

    @Inject
    public NxApplication(EventBus eventBus, NexusConfiguration nexusConfiguration, NexusPluginManager nexusPluginManager, ApplicationStatusSource applicationStatusSource, SecuritySystem securitySystem, NexusScheduler nexusScheduler, RepositoryRegistry repositoryRegistry, EventSubscriberHost eventSubscriberHost) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
        this.nexusPluginManager = (NexusPluginManager)Preconditions.checkNotNull((Object)nexusPluginManager);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.nexusScheduler = (NexusScheduler)Preconditions.checkNotNull((Object)nexusScheduler);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.eventSubscriberHost = (EventSubscriberHost)((Object)Preconditions.checkNotNull((Object)((Object)eventSubscriberHost)));
        this.logInitialized();
        this.log.info("Activating locally installed plugins...");
        Collection<PluginManagerResponse> activationResponse = this.nexusPluginManager.activateInstalledPlugins();
        for (PluginManagerResponse response : activationResponse) {
            if (response.isSuccessful()) {
                this.log.info(response.formatAsString(this.log.isDebugEnabled()));
                continue;
            }
            this.log.warn(response.formatAsString(this.log.isDebugEnabled()));
        }
        eventSubscriberHost.startup();
        applicationStatusSource.setState(SystemState.STOPPED);
        applicationStatusSource.getSystemStatus().setInitializedAt(new Date());
        eventBus.post((Object)new NexusInitializedEvent((Object)this));
    }

    @VisibleForTesting
    protected void logInitialized() {
        StringBuilder sysInfoLog = new StringBuilder();
        sysInfoLog.append("\n-------------------------------------------------\n\n");
        sysInfoLog.append("Initializing ").append(this.getNexusNameForLogs());
        sysInfoLog.append("\n\n-------------------------------------------------");
        this.log.info(sysInfoLog.toString());
    }

    @VisibleForTesting
    protected final String getNexusNameForLogs() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.applicationStatusSource.getSystemStatus().getAppName());
        msg.append(" ").append(this.applicationStatusSource.getSystemStatus().getVersion());
        return msg.toString();
    }

    protected void doStart() {
        this.applicationStatusSource.getSystemStatus().setState(SystemState.STARTING);
        try {
            this.nexusConfiguration.loadConfiguration(true);
            this.securitySystem.start();
            this.securitySystem.getAnonymousUsername();
            this.nexusConfiguration.createInternals();
            this.nexusScheduler.initializeTasks();
            this.eventBus.post((Object)new ConfigurationChangeEvent(this.nexusConfiguration, null, null));
            this.applicationStatusSource.getSystemStatus().setLastConfigChange(new Date());
            this.applicationStatusSource.getSystemStatus().setFirstStart(this.nexusConfiguration.isConfigurationDefaulted());
            this.applicationStatusSource.getSystemStatus().setInstanceUpgraded(this.nexusConfiguration.isInstanceUpgraded());
            this.applicationStatusSource.getSystemStatus().setConfigurationUpgraded(this.nexusConfiguration.isConfigurationUpgraded());
            if (this.applicationStatusSource.getSystemStatus().isFirstStart()) {
                this.log.info("This is 1st start of new Nexus instance.");
            }
            if (this.applicationStatusSource.getSystemStatus().isInstanceUpgraded()) {
                this.log.info("This is an upgraded instance of Nexus.");
            }
            this.applicationStatusSource.getSystemStatus().setState(SystemState.STARTED);
            this.applicationStatusSource.getSystemStatus().setStartedAt(new Date());
            this.synchronizeShadowsAtStartup();
            if (this.log.isInfoEnabled()) {
                File workDir = this.nexusConfiguration.getWorkingDirectory();
                String workDirPath = null;
                if (workDir != null) {
                    try {
                        workDirPath = workDir.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        workDirPath = workDir.getAbsolutePath();
                    }
                }
                this.log.info("Nexus Work Directory : {}", (Object)workDirPath);
                this.log.info("Started {}", (Object)this.getNexusNameForLogs());
            }
            this.eventBus.post((Object)new NexusStartedEvent((Object)this));
        }
        catch (IOException e) {
            this.applicationStatusSource.getSystemStatus().setState(SystemState.BROKEN_IO);
            this.applicationStatusSource.getSystemStatus().setErrorCause(e);
            this.log.error("Could not start Nexus, bad IO exception!", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (ConfigurationException e) {
            this.applicationStatusSource.getSystemStatus().setState(SystemState.BROKEN_CONFIGURATION);
            this.applicationStatusSource.getSystemStatus().setErrorCause(e);
            this.log.error("Could not start Nexus, user configuration exception!", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void doStop() {
        this.applicationStatusSource.getSystemStatus().setState(SystemState.STOPPING);
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        this.log.info("Uptime: {}", (Object)PeriodFormat.getDefault().print((ReadablePeriod)new Period(uptime)));
        this.eventBus.post((Object)new NexusStoppingEvent((Object)this));
        this.nexusScheduler.shutdown();
        this.eventBus.post((Object)new NexusStoppedEvent((Object)this));
        this.eventSubscriberHost.shutdown();
        this.nexusConfiguration.dropInternals();
        this.securitySystem.stop();
        this.applicationStatusSource.getSystemStatus().setState(SystemState.STOPPED);
        this.log.info("Stopped {}", (Object)this.getNexusNameForLogs());
    }

    private void synchronizeShadowsAtStartup() {
        List<ShadowRepository> shadows = this.repositoryRegistry.getRepositoriesWithFacet(ShadowRepository.class);
        for (ShadowRepository shadow : shadows) {
            if (!shadow.isSynchronizeAtStartup()) continue;
            SynchronizeShadowsTask task = this.nexusScheduler.createTaskInstance(SynchronizeShadowsTask.class);
            task.setShadowRepositoryId(shadow.getId());
            this.nexusScheduler.submit("Shadow Sync (" + shadow.getId() + ")", task);
        }
    }
}

