/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    public static final long UNLIMITED = -1L;
    private final InputStream is;
    private final long from;
    private final long count;
    private long readAlready = 0L;

    public LimitedInputStream(InputStream is, long from, long count) throws IOException {
        this.is = is;
        this.from = from;
        this.count = count;
        is.skip(from);
    }

    public InputStream getIs() {
        return this.is;
    }

    public long getFrom() {
        return this.from;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        if (this.readAlready > this.count) {
            return -1;
        }
        ++this.readAlready;
        return this.is.read();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

