/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemState;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractApplicationStatusSource
extends ComponentSupport
implements ApplicationStatusSource {
    private final SystemStatus systemStatus = new SystemStatus();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long lastUpdate = -1L;

    protected SystemStatus getSystemStatusInternal() {
        return this.systemStatus;
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public SystemStatus getSystemStatus() {
        this.updateSystemStatusIfNeeded(false);
        Lock lock = this.getLock().readLock();
        lock.lock();
        try {
            SystemStatus systemStatus = this.getSystemStatusInternal();
            return systemStatus;
        }
        finally {
            lock.unlock();
        }
    }

    public void updateSystemStatus() {
        this.updateSystemStatusIfNeeded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setState(SystemState state) {
        Lock lock = this.getLock().writeLock();
        lock.lock();
        try {
            this.getSystemStatusInternal().setState(state);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected String readVersion(String path) {
        String version = "Unknown";
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getResourceAsStream(path);
            if (is != null) {
                props.load(is);
                version = props.getProperty("version");
            }
        }
        catch (IOException e) {
            this.log.error("Could not load/read version from: {}", (Object)path, (Object)e);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSystemStatusIfNeeded(boolean forced) {
        long currentTime = System.currentTimeMillis();
        if (forced || currentTime - this.lastUpdate > 30000L) {
            Lock lock = this.getLock().writeLock();
            lock.lock();
            try {
                if (forced || currentTime - this.lastUpdate > 30000L) {
                    this.renewSystemStatus(this.getSystemStatusInternal());
                    this.lastUpdate = currentTime;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected abstract String discoverApplicationVersion();

    protected abstract void renewSystemStatus(SystemStatus var1);
}

