/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement.xml;

import com.google.common.base.Throwables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.credential.PasswordService;
import org.eclipse.sisu.Description;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.realms.tools.NoSuchRoleMappingException;
import org.sonatype.security.usermanagement.AbstractUserManager;
import org.sonatype.security.usermanagement.DefaultUser;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.RoleMappingUserManager;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserSearchCriteria;
import org.sonatype.security.usermanagement.UserStatus;

@Singleton
@Typed(value={UserManager.class})
@Named(value="default")
@Description(value="Default")
public class SecurityXmlUserManager
extends AbstractUserManager
implements RoleMappingUserManager {
    public static final String SOURCE = "default";
    private final ConfigurationManager configuration;
    private final SecuritySystem securitySystem;
    private final PasswordService passwordService;

    @Inject
    public SecurityXmlUserManager(@Named(value="default") ConfigurationManager configuration, SecuritySystem securitySystem, PasswordService passwordService) {
        this.configuration = configuration;
        this.securitySystem = securitySystem;
        this.passwordService = passwordService;
    }

    protected CUser toUser(User user) {
        if (user == null) {
            return null;
        }
        CUser secUser = new CUser();
        secUser.setId(user.getUserId());
        secUser.setFirstName(user.getFirstName());
        secUser.setLastName(user.getLastName());
        secUser.setEmail(user.getEmailAddress());
        secUser.setStatus(user.getStatus().name());
        return secUser;
    }

    protected User toUser(CUser cUser) {
        if (cUser == null) {
            return null;
        }
        DefaultUser user = new DefaultUser();
        user.setUserId(cUser.getId());
        user.setFirstName(cUser.getFirstName());
        user.setLastName(cUser.getLastName());
        user.setEmailAddress(cUser.getEmail());
        user.setSource(SOURCE);
        user.setStatus(UserStatus.valueOf((String)cUser.getStatus()));
        try {
            user.setRoles(this.getUsersRoles(cUser.getId(), SOURCE));
        }
        catch (UserNotFoundException e) {
            this.log.warn("Could not find user: '" + cUser.getId() + "' of source: '" + SOURCE + "' while looking up the users roles.", (Throwable)e);
        }
        return user;
    }

    protected RoleIdentifier toRole(String roleId) {
        if (roleId == null) {
            return null;
        }
        try {
            CRole role = this.configuration.readRole(roleId);
            RoleIdentifier roleIdentifier = new RoleIdentifier(SOURCE, role.getId());
            return roleIdentifier;
        }
        catch (NoSuchRoleException e) {
            return null;
        }
    }

    public Set<User> listUsers() {
        HashSet<User> users = new HashSet<User>();
        for (CUser user : this.configuration.listUsers()) {
            users.add(this.toUser(user));
        }
        return users;
    }

    public Set<String> listUserIds() {
        HashSet<String> userIds = new HashSet<String>();
        for (CUser user : this.configuration.listUsers()) {
            userIds.add(user.getId());
        }
        return userIds;
    }

    public User getUser(String userId) throws UserNotFoundException {
        User user = this.toUser(this.configuration.readUser(userId));
        return user;
    }

    public String getSource() {
        return SOURCE;
    }

    public boolean supportsWrite() {
        return true;
    }

    public User addUser(final User user, String password) throws InvalidConfigurationException {
        final CUser secUser = this.toUser(user);
        secUser.setPassword(this.hashPassword(password));
        try {
            this.configuration.runWrite(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    SecurityXmlUserManager.this.configuration.createUser(secUser, SecurityXmlUserManager.this.getRoleIdsFromUser(user));
                    SecurityXmlUserManager.this.saveConfiguration();
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, InvalidConfigurationException.class);
            throw Throwables.propagate((Throwable)e);
        }
        return user;
    }

    public void changePassword(final String userId, final String newPassword) throws UserNotFoundException, InvalidConfigurationException {
        try {
            this.configuration.runWrite(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    CUser secUser = SecurityXmlUserManager.this.configuration.readUser(userId);
                    secUser.setPassword(SecurityXmlUserManager.this.hashPassword(newPassword));
                    SecurityXmlUserManager.this.configuration.updateUser(secUser);
                    SecurityXmlUserManager.this.saveConfiguration();
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, UserNotFoundException.class, InvalidConfigurationException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public User updateUser(final User user) throws UserNotFoundException, InvalidConfigurationException {
        try {
            this.configuration.runWrite(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    CUser oldSecUser = SecurityXmlUserManager.this.configuration.readUser(user.getUserId());
                    CUser newSecUser = SecurityXmlUserManager.this.toUser(user);
                    newSecUser.setPassword(oldSecUser.getPassword());
                    SecurityXmlUserManager.this.configuration.updateUser(newSecUser, SecurityXmlUserManager.this.getRoleIdsFromUser(user));
                    SecurityXmlUserManager.this.saveConfiguration();
                }
            });
            return user;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, UserNotFoundException.class, InvalidConfigurationException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void deleteUser(final String userId) throws UserNotFoundException {
        try {
            this.configuration.runWrite(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    SecurityXmlUserManager.this.configuration.deleteUser(userId);
                    SecurityXmlUserManager.this.saveConfiguration();
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, UserNotFoundException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Set<RoleIdentifier> getUsersRoles(final String userId, final String source) throws UserNotFoundException {
        final HashSet<RoleIdentifier> roles = new HashSet<RoleIdentifier>();
        try {
            this.configuration.runRead(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    try {
                        CUserRoleMapping roleMapping = SecurityXmlUserManager.this.configuration.readUserRoleMapping(userId, source);
                        if (roleMapping != null) {
                            for (String roleId : roleMapping.getRoles()) {
                                RoleIdentifier role = SecurityXmlUserManager.this.toRole(roleId);
                                if (role == null) continue;
                                roles.add(role);
                            }
                        }
                    }
                    catch (NoSuchRoleMappingException e) {
                        SecurityXmlUserManager.this.log.debug("No user role mapping found for user: " + userId);
                    }
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, UserNotFoundException.class);
            throw Throwables.propagate((Throwable)e);
        }
        return roles;
    }

    private void saveConfiguration() {
        this.configuration.save();
    }

    public Set<User> searchUsers(final UserSearchCriteria criteria) {
        final HashSet<User> users = new HashSet<User>();
        try {
            this.configuration.runRead(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    users.addAll(SecurityXmlUserManager.this.filterListInMemeory(SecurityXmlUserManager.this.listUsers(), criteria));
                    List<CUserRoleMapping> roleMappings = SecurityXmlUserManager.this.configuration.listUserRoleMappings();
                    for (CUserRoleMapping roleMapping : roleMappings) {
                        if (SecurityXmlUserManager.SOURCE.equals(roleMapping.getSource()) || !SecurityXmlUserManager.this.matchesCriteria(roleMapping.getUserId(), roleMapping.getSource(), roleMapping.getRoles(), criteria)) continue;
                        try {
                            User user = SecurityXmlUserManager.this.getSecuritySystem().getUser(roleMapping.getUserId(), roleMapping.getSource());
                            users.add(user);
                        }
                        catch (UserNotFoundException e) {
                            SecurityXmlUserManager.this.log.debug("User: '" + roleMapping.getUserId() + "' of source: '" + roleMapping.getSource() + "' could not be found.", (Throwable)e);
                        }
                        catch (NoSuchUserManagerException e) {
                            SecurityXmlUserManager.this.log.warn("User: '" + roleMapping.getUserId() + "' of source: '" + roleMapping.getSource() + "' could not be found.", (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return users;
    }

    private SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    private String hashPassword(String clearPassword) {
        if (clearPassword != null && clearPassword.trim().length() > 0) {
            return this.passwordService.encryptPassword((Object)clearPassword);
        }
        return clearPassword;
    }

    public void setUsersRoles(final String userId, final String userSource, final Set<RoleIdentifier> roleIdentifiers) throws UserNotFoundException, InvalidConfigurationException {
        try {
            this.configuration.runWrite(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    if (roleIdentifiers == null || roleIdentifiers.isEmpty()) {
                        try {
                            SecurityXmlUserManager.this.configuration.deleteUserRoleMapping(userId, userSource);
                        }
                        catch (NoSuchRoleMappingException e) {
                            SecurityXmlUserManager.this.log.debug("User role mapping for user: " + userId + " source: " + userSource + " could not be deleted because it does not exist.");
                        }
                    } else {
                        CUserRoleMapping roleMapping = new CUserRoleMapping();
                        roleMapping.setUserId(userId);
                        roleMapping.setSource(userSource);
                        for (RoleIdentifier roleIdentifier : roleIdentifiers) {
                            if (!SecurityXmlUserManager.this.getSource().equals(roleIdentifier.getSource())) continue;
                            roleMapping.addRole(roleIdentifier.getRoleId());
                        }
                        try {
                            SecurityXmlUserManager.this.configuration.updateUserRoleMapping(roleMapping);
                        }
                        catch (NoSuchRoleMappingException e) {
                            SecurityXmlUserManager.this.log.debug("Update of user role mapping for user: " + userId + " source: " + userSource + " did not exist, creating new one.");
                            SecurityXmlUserManager.this.configuration.createUserRoleMapping(roleMapping);
                        }
                    }
                    SecurityXmlUserManager.this.saveConfiguration();
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, UserNotFoundException.class, InvalidConfigurationException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String getAuthenticationRealmName() {
        return "XmlAuthenticatingRealm";
    }

    private Set<String> getRoleIdsFromUser(User user) {
        HashSet<String> roles = new HashSet<String>();
        for (RoleIdentifier roleIdentifier : user.getRoles()) {
            roles.add(roleIdentifier.getRoleId());
        }
        return roles;
    }
}

