/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.Description;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.usermanagement.AbstractReadOnlyUserManager;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserSearchCriteria;

@Singleton
@Typed(value={UserManager.class})
@Named(value="allConfigured")
@Description(value="All Configured Users")
public class ConfiguredUsersUserManager
extends AbstractReadOnlyUserManager {
    private final SecuritySystem securitySystem;
    private final ConfigurationManager configuration;
    public static final String SOURCE = "allConfigured";

    @Inject
    public ConfiguredUsersUserManager(SecuritySystem securitySystem, @Named(value="default") ConfigurationManager configuration) {
        this.securitySystem = securitySystem;
        this.configuration = configuration;
    }

    public String getSource() {
        return SOURCE;
    }

    public Set<User> listUsers() {
        HashSet<User> users = new HashSet<User>();
        List<CUserRoleMapping> userRoleMappings = this.configuration.listUserRoleMappings();
        for (CUserRoleMapping userRoleMapping : userRoleMappings) {
            try {
                User user = this.getSecuritySystem().getUser(userRoleMapping.getUserId(), userRoleMapping.getSource());
                if (user == null) continue;
                users.add(user);
            }
            catch (UserNotFoundException e) {
                this.log.warn("User: '" + userRoleMapping.getUserId() + "' of source: '" + userRoleMapping.getSource() + "' could not be found.");
                this.log.debug("Most likely caused by a user role mapping that is invalid.", (Throwable)e);
            }
            catch (NoSuchUserManagerException e) {
                this.log.warn("User: '" + userRoleMapping.getUserId() + "' of source: '" + userRoleMapping.getSource() + "' could not be found.", (Throwable)e);
            }
        }
        return users;
    }

    public Set<String> listUserIds() {
        HashSet<String> userIds = new HashSet<String>();
        HashSet users = new HashSet();
        for (User user : users) {
            userIds.add(user.getUserId());
        }
        List<CUserRoleMapping> userRoleMappings = this.configuration.listUserRoleMappings();
        for (CUserRoleMapping userRoleMapping : userRoleMappings) {
            String userId = userRoleMapping.getUserId();
            if (!StringUtils.isNotEmpty((String)userId)) continue;
            userIds.add(userId);
        }
        return userIds;
    }

    public User getUser(String userId) {
        return null;
    }

    public Set<User> searchUsers(UserSearchCriteria criteria) {
        if (this.getSource().equals(criteria.getSource())) {
            return this.filterListInMemeory(this.listUsers(), criteria);
        }
        return new HashSet<User>();
    }

    private SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    protected boolean matchesCriteria(String userId, String userSource, Collection<String> usersRoles, UserSearchCriteria criteria) {
        if (StringUtils.isNotEmpty((String)criteria.getUserId()) && !userId.toLowerCase().startsWith(criteria.getUserId().toLowerCase())) {
            return false;
        }
        if (criteria.getOneOfRoleIds() != null && !criteria.getOneOfRoleIds().isEmpty()) {
            HashSet<String> userRoles = new HashSet<String>();
            if (usersRoles != null) {
                userRoles.addAll(usersRoles);
            }
            if (CollectionUtils.intersection((Collection)criteria.getOneOfRoleIds(), userRoles).isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public String getAuthenticationRealmName() {
        return null;
    }
}

