/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationContext;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationRequest;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.validator.ConfigurationIdGenerator;
import org.sonatype.security.realms.validator.SecurityConfigurationValidator;
import org.sonatype.security.realms.validator.SecurityValidationContext;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={SecurityConfigurationValidator.class})
@Named(value="default")
public class DefaultConfigurationValidator
extends ComponentSupport
implements SecurityConfigurationValidator {
    private static String DEFAULT_SOURCE = "default";
    private final ConfigurationIdGenerator idGenerator;
    private final List<PrivilegeDescriptor> privilegeDescriptors;

    @Inject
    public DefaultConfigurationValidator(List<PrivilegeDescriptor> privilegeDescriptors, ConfigurationIdGenerator idGenerator) {
        this.privilegeDescriptors = privilegeDescriptors;
        this.idGenerator = idGenerator;
    }

    @Override
    public ValidationResponse validateModel(ValidationRequest<Configuration> request) {
        List<CUserRoleMapping> list;
        List<CRole> roles;
        ValidationResponse response = new ValidationResponse();
        response.setContext((ValidationContext)new SecurityValidationContext());
        Configuration model = (Configuration)request.getConfiguration();
        SecurityValidationContext context = (SecurityValidationContext)response.getContext();
        List<CPrivilege> privs = model.getPrivileges();
        if (privs != null) {
            for (CPrivilege cPrivilege : privs) {
                response.append(this.validatePrivilege(context, cPrivilege, false));
            }
        }
        if ((roles = model.getRoles()) != null) {
            for (CRole cRole : roles) {
                response.append(this.validateRole(context, cRole, false));
            }
        }
        response.append(this.validateRoleContainment(context));
        List<CUser> list2 = model.getUsers();
        if (list2 != null) {
            for (CUser user : list2) {
                HashSet<String> roleIds = new HashSet<String>();
                for (CUserRoleMapping userRoleMapping : model.getUserRoleMappings()) {
                    if (userRoleMapping.getUserId() == null || !userRoleMapping.getUserId().equals(user.getId()) || !DEFAULT_SOURCE.equals(userRoleMapping.getSource())) continue;
                    roleIds.addAll(userRoleMapping.getRoles());
                }
                response.append(this.validateUser(context, user, roleIds, false));
            }
        }
        if ((list = model.getUserRoleMappings()) != null) {
            for (CUserRoleMapping userRoleMapping : list) {
                response.append(this.validateUserRoleMapping(context, userRoleMapping, false));
            }
        }
        if (response.getValidationErrors().size() > 0 || response.getValidationWarnings().size() > 0) {
            this.log.error("* * * * * * * * * * * * * * * * * * * * * * * * * *");
            this.log.error("Security configuration has validation errors/warnings");
            this.log.error("* * * * * * * * * * * * * * * * * * * * * * * * * *");
            if (response.getValidationErrors().size() > 0) {
                this.log.error("The ERRORS:");
                for (ValidationMessage msg : response.getValidationErrors()) {
                    this.log.error(msg.toString());
                }
            }
            if (response.getValidationWarnings().size() > 0) {
                this.log.error("The WARNINGS:");
                for (ValidationMessage msg : response.getValidationWarnings()) {
                    this.log.error(msg.toString());
                }
            }
            this.log.error("* * * * * * * * * * * * * * * * * * * * *");
        } else {
            this.log.info("Security configuration validated succesfully.");
        }
        return response;
    }

    @Override
    public ValidationResponse validatePrivilege(SecurityValidationContext ctx, CPrivilege privilege, boolean update) {
        ValidationResponse response = new ValidationResponse();
        if (ctx != null) {
            response.setContext((ValidationContext)ctx);
        }
        for (PrivilegeDescriptor descriptor : this.privilegeDescriptors) {
            ValidationResponse resp = descriptor.validatePrivilege(privilege, ctx, update);
            if (resp == null) continue;
            response.append(resp);
        }
        ctx.getExistingPrivilegeIds().add(privilege.getId());
        return response;
    }

    @Override
    public ValidationResponse validateRoleContainment(SecurityValidationContext ctx) {
        SecurityValidationContext context;
        ValidationResponse response = new ValidationResponse();
        if (ctx != null) {
            response.setContext((ValidationContext)ctx);
        }
        if ((context = (SecurityValidationContext)response.getContext()).getExistingRoleIds() != null) {
            for (String roleId : context.getExistingRoleIds()) {
                response.append(this.isRecursive(roleId, roleId, ctx));
            }
        }
        return response;
    }

    private boolean isRoleNameAlreadyInUse(Map<String, String> existingRoleNameMap, CRole role) {
        for (String roleId : existingRoleNameMap.keySet()) {
            if (roleId.equals(role.getId()) || !existingRoleNameMap.get(roleId).equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    private String getRoleTextForDisplay(String roleId, SecurityValidationContext ctx) {
        String name = ctx.getExistingRoleNameMap().get(roleId);
        if (StringUtils.isEmpty((String)name)) {
            return roleId;
        }
        return name;
    }

    private ValidationResponse isRecursive(String baseRoleId, String roleId, SecurityValidationContext ctx) {
        ValidationResponse response = new ValidationResponse();
        List<String> containedRoles = ctx.getRoleContainmentMap().get(roleId);
        for (String containedRoleId : containedRoles) {
            ValidationMessage message;
            if (baseRoleId.equals(roleId) && !ctx.getExistingRoleIds().contains(roleId)) {
                message = new ValidationMessage("roles", "Role '" + this.getRoleTextForDisplay(baseRoleId, ctx) + "' contains an invalid role", "Role cannot contain invalid role '" + this.getRoleTextForDisplay(roleId, ctx) + "'.");
                response.addValidationWarning(message);
            }
            if (containedRoleId.equals(baseRoleId)) {
                message = new ValidationMessage("roles", "Role '" + this.getRoleTextForDisplay(baseRoleId, ctx) + "' contains itself through Role '" + this.getRoleTextForDisplay(roleId, ctx) + "'.  This is not valid.", "Role cannot contain itself recursively (via role '" + this.getRoleTextForDisplay(roleId, ctx) + "').");
                response.addValidationError(message);
                break;
            }
            if (ctx.getExistingRoleIds().contains(containedRoleId)) {
                response.append(this.isRecursive(baseRoleId, containedRoleId, ctx));
                continue;
            }
            if (!baseRoleId.equals(roleId)) continue;
            message = new ValidationMessage("roles", "Role '" + this.getRoleTextForDisplay(roleId, ctx) + "' contains an invalid role '" + this.getRoleTextForDisplay(containedRoleId, ctx) + "'.", "Role cannot contain invalid role '" + this.getRoleTextForDisplay(containedRoleId, ctx) + "'.");
            response.addValidationWarning(message);
        }
        return response;
    }

    @Override
    public ValidationResponse validateRole(SecurityValidationContext ctx, CRole role, boolean update) {
        ValidationMessage message;
        ValidationMessage message2;
        SecurityValidationContext context;
        List<String> existingIds;
        ValidationResponse response = new ValidationResponse();
        if (ctx != null) {
            response.setContext((ValidationContext)ctx);
        }
        if ((existingIds = (context = (SecurityValidationContext)response.getContext()).getExistingRoleIds()) == null) {
            context.addExistingRoleIds();
            existingIds = context.getExistingRoleIds();
        }
        if (!update && existingIds.contains(role.getId())) {
            message2 = new ValidationMessage("id", "Role ID must be unique.");
            response.addValidationError(message2);
        }
        if (update && !existingIds.contains(role.getId())) {
            message2 = new ValidationMessage("id", "Role ID cannot be changed.");
            response.addValidationError(message2);
        }
        if (!update && (StringUtils.isEmpty((String)role.getId()) || "0".equals(role.getId()))) {
            String newId = this.idGenerator.generateId();
            response.addValidationWarning("Fixed wrong role ID from '" + role.getId() + "' to '" + newId + "'");
            role.setId(newId);
            response.setModified(true);
        }
        Map<String, String> existingRoleNameMap = context.getExistingRoleNameMap();
        if (StringUtils.isEmpty((String)role.getName())) {
            message = new ValidationMessage("name", "Role ID '" + role.getId() + "' requires a name.", "Name is required.");
            response.addValidationError(message);
        } else if (this.isRoleNameAlreadyInUse(existingRoleNameMap, role)) {
            message = new ValidationMessage("name", "Role ID '" + role.getId() + "' can't use the name '" + role.getName() + "'.", "Name is already in use.");
            response.addValidationError(message);
        } else {
            existingRoleNameMap.put(role.getId(), role.getName());
        }
        if (context.getExistingPrivilegeIds() != null) {
            List<String> privIds = role.getPrivileges();
            for (String privId : privIds) {
                if (context.getExistingPrivilegeIds().contains(privId)) continue;
                ValidationMessage message3 = new ValidationMessage("privileges", "Role ID '" + role.getId() + "' Invalid privilege id '" + privId + "' found.", "Role cannot contain invalid privilege ID '" + privId + "'.");
                response.addValidationWarning(message3);
            }
        }
        List<String> roleIds = role.getRoles();
        List<String> containedRoles = context.getRoleContainmentMap().get(role.getId());
        if (containedRoles == null) {
            containedRoles = new ArrayList<String>();
            context.getRoleContainmentMap().put(role.getId(), containedRoles);
        }
        for (String roleId : roleIds) {
            if (roleId.equals(role.getId())) {
                ValidationMessage message4 = new ValidationMessage("roles", "Role ID '" + role.getId() + "' cannot contain itself.", "Role cannot contain itself.");
                response.addValidationError(message4);
                continue;
            }
            if (context.getRoleContainmentMap() == null) continue;
            containedRoles.add(roleId);
        }
        if (update) {
            response.append(this.isRecursive(role.getId(), role.getId(), context));
        }
        existingIds.add(role.getId());
        return response;
    }

    @Override
    public ValidationResponse validateUser(SecurityValidationContext ctx, CUser user, Set<String> roles, boolean update) {
        ValidationMessage message;
        SecurityValidationContext context;
        List<String> existingIds;
        ValidationResponse response = new ValidationResponse();
        if (ctx != null) {
            response.setContext((ValidationContext)ctx);
        }
        if ((existingIds = (context = (SecurityValidationContext)response.getContext()).getExistingUserIds()) == null) {
            context.addExistingUserIds();
            existingIds = context.getExistingUserIds();
        }
        if (!update && StringUtils.isEmpty((String)user.getId())) {
            message = new ValidationMessage("userId", "User ID is required.", "User ID is required.");
            response.addValidationError(message);
        }
        if (!update && StringUtils.isNotEmpty((String)user.getId()) && existingIds.contains(user.getId())) {
            message = new ValidationMessage("userId", "User ID '" + user.getId() + "' is already in use.", "User ID '" + user.getId() + "' is already in use.");
            response.addValidationError(message);
        }
        if (StringUtils.isNotEmpty((String)user.getId()) && user.getId().contains(" ")) {
            message = new ValidationMessage("userId", "User ID '" + user.getId() + "' cannot contain spaces.", "User ID '" + user.getId() + "' cannot contain spaces.");
            response.addValidationError(message);
        }
        if (StringUtils.isNotEmpty((String)user.getFirstName())) {
            user.setFirstName(user.getFirstName());
        }
        if (StringUtils.isNotEmpty((String)user.getLastName())) {
            user.setLastName(user.getLastName());
        }
        if (StringUtils.isEmpty((String)user.getPassword())) {
            message = new ValidationMessage("password", "User ID '" + user.getId() + "' has no password.  This is a required field.", "Password is required.");
            response.addValidationError(message);
        }
        if (StringUtils.isEmpty((String)user.getEmail())) {
            message = new ValidationMessage("email", "User ID '" + user.getId() + "' has no email address", "Email address is required.");
            response.addValidationError(message);
        } else {
            try {
                if (!user.getEmail().matches(".+@.+")) {
                    message = new ValidationMessage("email", "User ID '" + user.getId() + "' has an invalid email address.", "Email address is invalid.");
                    response.addValidationError(message);
                }
            }
            catch (PatternSyntaxException e) {
                throw new IllegalStateException("Regex did not compile: " + e.getMessage(), e);
            }
        }
        if (!"active".equals(user.getStatus()) && !"disabled".equals(user.getStatus())) {
            message = new ValidationMessage("status", "User ID '" + user.getId() + "' has invalid status '" + user.getStatus() + "'.  (Allowed values are: " + "active" + " and " + "disabled" + ")", "Invalid Status selected.");
            response.addValidationError(message);
        }
        if (context.getExistingRoleIds() != null && context.getExistingUserRoleMap() != null && roles != null && roles.size() > 0) {
            for (String roleId : roles) {
                if (context.getExistingRoleIds().contains(roleId)) continue;
                ValidationMessage message2 = new ValidationMessage("roles", "User ID '" + user.getId() + "' Invalid role id '" + roleId + "' found.", "User cannot contain invalid role ID '" + roleId + "'.");
                response.addValidationError(message2);
            }
        }
        if (!StringUtils.isEmpty((String)user.getId())) {
            existingIds.add(user.getId());
        }
        return response;
    }

    @Override
    public ValidationResponse validateUserRoleMapping(SecurityValidationContext context, CUserRoleMapping userRoleMapping, boolean update) {
        ValidationMessage message;
        ValidationResponse response = new ValidationResponse();
        if (StringUtils.isEmpty((String)userRoleMapping.getUserId())) {
            message = new ValidationMessage("userId", "UserRoleMapping has no userId.  This is a required field.", "UserId is required.");
            response.addValidationError(message);
        }
        if (StringUtils.isEmpty((String)userRoleMapping.getSource())) {
            message = new ValidationMessage("source", "User Role Mapping for user '" + userRoleMapping.getUserId() + "' has no source.  This is a required field.", "UserId is required.");
            response.addValidationError(message);
        }
        List<String> roles = userRoleMapping.getRoles();
        if (context.getExistingRoleIds() != null && context.getExistingUserRoleMap() != null && roles != null && roles.size() > 0) {
            for (String roleId : roles) {
                if (context.getExistingRoleIds().contains(roleId)) continue;
                ValidationMessage message2 = new ValidationMessage("roles", "User Role Mapping for user '" + userRoleMapping.getUserId() + "' Invalid role id '" + roleId + "' found.", "User cannot contain invalid role ID '" + roleId + "'.");
                response.addValidationError(message2);
            }
        }
        return response;
    }
}

