/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.tools.AbstractConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.realms.tools.DynamicSecurityResource;
import org.sonatype.security.realms.tools.NoSuchRoleMappingException;
import org.sonatype.security.realms.tools.StaticSecurityResource;
import org.sonatype.security.realms.validator.SecurityValidationContext;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Typed(value={ConfigurationManager.class})
@Named(value="resourceMerging")
public class ResourceMergingConfigurationManager
extends AbstractConfigurationManager {
    private final ConfigurationManager manager;
    private final List<StaticSecurityResource> staticResources;
    private final List<DynamicSecurityResource> dynamicResources;

    @Inject
    public ResourceMergingConfigurationManager(EventBus eventBus, List<DynamicSecurityResource> dynamicResources, @Named(value="legacydefault") ConfigurationManager manager, List<StaticSecurityResource> staticResources) {
        super(eventBus);
        this.dynamicResources = dynamicResources;
        this.manager = manager;
        this.staticResources = staticResources;
    }

    @Override
    public void runRead(ConfigurationManagerAction action) throws Exception {
        throw new UnsupportedOperationException("Concurrent access not supported. ConcurrentConfigurationManager should be used instead");
    }

    @Override
    public void runWrite(ConfigurationManagerAction action) throws Exception {
        throw new UnsupportedOperationException("Concurrent access not supported. ConcurrentConfigurationManager should be used instead");
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.manager.clearCache();
    }

    @Override
    public void createPrivilege(CPrivilege privilege) throws InvalidConfigurationException {
        this.manager.createPrivilege(privilege, this.initializeContext());
    }

    @Override
    public void createPrivilege(CPrivilege privilege, SecurityValidationContext context) throws InvalidConfigurationException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.createPrivilege(privilege, context);
    }

    @Override
    public void createRole(CRole role) throws InvalidConfigurationException {
        this.manager.createRole(role, this.initializeContext());
    }

    @Override
    public void createRole(CRole role, SecurityValidationContext context) throws InvalidConfigurationException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.createRole(role, context);
    }

    @Override
    public void createUser(CUser user, Set<String> roles) throws InvalidConfigurationException {
        this.manager.createUser(user, roles, this.initializeContext());
    }

    @Override
    public void createUser(CUser user, String password, Set<String> roles) throws InvalidConfigurationException {
        this.manager.createUser(user, password, roles, this.initializeContext());
    }

    @Override
    public void createUser(CUser user, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException {
        this.createUser(user, null, roles, context);
    }

    @Override
    public void createUser(CUser user, String password, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.createUser(user, password, roles, context);
    }

    @Override
    public void deletePrivilege(String id) throws NoSuchPrivilegeException {
        this.manager.deletePrivilege(id);
    }

    @Override
    public void deleteRole(String id) throws NoSuchRoleException {
        this.manager.deleteRole(id);
    }

    @Override
    public void deleteUser(String id) throws UserNotFoundException {
        this.manager.deleteUser(id);
    }

    @Override
    public String getPrivilegeProperty(CPrivilege privilege, String key) {
        return this.manager.getPrivilegeProperty(privilege, key);
    }

    @Override
    public String getPrivilegeProperty(String id, String key) throws NoSuchPrivilegeException {
        return this.manager.getPrivilegeProperty(id, key);
    }

    @Override
    public SecurityValidationContext initializeContext() {
        SecurityValidationContext context = new SecurityValidationContext();
        context.addExistingUserIds();
        context.addExistingRoleIds();
        context.addExistingPrivilegeIds();
        ArrayList<CUser> users = new ArrayList<CUser>(this.listUsers());
        for (CUser cUser : users) {
            context.getExistingUserIds().add(cUser.getId());
            context.getExistingEmailMap().put(cUser.getId(), cUser.getEmail());
        }
        ArrayList<CRole> roles = new ArrayList<CRole>(this.listRoles());
        for (CRole role : roles) {
            context.getExistingRoleIds().add(role.getId());
            ArrayList<String> containedRoles = new ArrayList<String>();
            containedRoles.addAll(role.getRoles());
            context.getRoleContainmentMap().put(role.getId(), containedRoles);
            context.getExistingRoleNameMap().put(role.getId(), role.getName());
        }
        ArrayList<CPrivilege> arrayList = new ArrayList<CPrivilege>(this.listPrivileges());
        for (CPrivilege priv : arrayList) {
            context.getExistingPrivilegeIds().add(priv.getId());
        }
        return context;
    }

    @Override
    public List<CPrivilege> listPrivileges() {
        ArrayList<CPrivilege> list = new ArrayList<CPrivilege>(this.manager.listPrivileges());
        for (CPrivilege item : this.getConfiguration().getPrivileges()) {
            item.setReadOnly(true);
            list.add(item);
        }
        return list;
    }

    @Override
    public List<CRole> listRoles() {
        ArrayList<CRole> list = new ArrayList<CRole>(this.manager.listRoles());
        Iterator<CRole> iterator = this.getConfiguration().getRoles().iterator();
        while (iterator.hasNext()) {
            CRole item;
            CRole role = item = iterator.next();
            item.setReadOnly(true);
            list.add(role);
        }
        return list;
    }

    private CRole mergeRolesContents(CRole roleA, CRole roleB) {
        HashSet<String> roles = new HashSet<String>();
        if (roleA.getRoles() != null) {
            roles.addAll(roleA.getRoles());
        }
        if (roleB.getRoles() != null) {
            roles.addAll(roleB.getRoles());
        }
        HashSet<String> privs = new HashSet<String>();
        if (roleA.getPrivileges() != null) {
            privs.addAll(roleA.getPrivileges());
        }
        if (roleB.getPrivileges() != null) {
            privs.addAll(roleB.getPrivileges());
        }
        CRole newRole = new CRole();
        newRole.setId(roleA.getId());
        newRole.setRoles(new ArrayList<String>(roles));
        newRole.setPrivileges(new ArrayList<String>(privs));
        if (StringUtils.isNotEmpty((String)roleA.getName())) {
            newRole.setName(roleA.getName());
        } else {
            newRole.setName(roleB.getName());
        }
        if (StringUtils.isNotEmpty((String)roleA.getDescription())) {
            newRole.setDescription(roleA.getDescription());
        } else {
            newRole.setDescription(roleB.getDescription());
        }
        if (roleA.getSessionTimeout() > roleB.getSessionTimeout()) {
            newRole.setSessionTimeout(roleA.getSessionTimeout());
        } else {
            newRole.setSessionTimeout(roleB.getSessionTimeout());
        }
        return newRole;
    }

    @Override
    public List<CUser> listUsers() {
        return this.manager.listUsers();
    }

    @Override
    public CPrivilege readPrivilege(String id) throws NoSuchPrivilegeException {
        CPrivilege privilege = this.getConfiguration().getPrivilegeById(id);
        if (privilege != null) {
            privilege.setReadOnly(true);
            return privilege;
        }
        return this.manager.readPrivilege(id);
    }

    @Override
    public CRole readRole(String id) throws NoSuchRoleException {
        CRole role = this.getConfiguration().getRoleById(id);
        if (role != null) {
            role.setReadOnly(true);
            return role;
        }
        return this.manager.readRole(id);
    }

    @Override
    public CUser readUser(String id) throws UserNotFoundException {
        return this.manager.readUser(id);
    }

    @Override
    public void createUserRoleMapping(CUserRoleMapping userRoleMapping, SecurityValidationContext context) throws InvalidConfigurationException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.createUserRoleMapping(userRoleMapping, context);
    }

    @Override
    public void createUserRoleMapping(CUserRoleMapping userRoleMapping) throws InvalidConfigurationException {
        this.manager.createUserRoleMapping(userRoleMapping, this.initializeContext());
    }

    @Override
    public void deleteUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        this.manager.deleteUserRoleMapping(userId, source);
    }

    @Override
    public List<CUserRoleMapping> listUserRoleMappings() {
        return this.manager.listUserRoleMappings();
    }

    @Override
    public CUserRoleMapping readUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        return this.manager.readUserRoleMapping(userId, source);
    }

    @Override
    public void updateUserRoleMapping(CUserRoleMapping userRoleMapping, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchRoleMappingException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.updateUserRoleMapping(userRoleMapping, context);
    }

    @Override
    public void updateUserRoleMapping(CUserRoleMapping userRoleMapping) throws InvalidConfigurationException, NoSuchRoleMappingException {
        this.updateUserRoleMapping(userRoleMapping, this.initializeContext());
    }

    @Override
    public void updatePrivilege(CPrivilege privilege) throws InvalidConfigurationException, NoSuchPrivilegeException {
        this.manager.updatePrivilege(privilege, this.initializeContext());
    }

    @Override
    public void updatePrivilege(CPrivilege privilege, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchPrivilegeException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.updatePrivilege(privilege, context);
    }

    @Override
    public void updateRole(CRole role) throws InvalidConfigurationException, NoSuchRoleException {
        this.manager.updateRole(role, this.initializeContext());
    }

    @Override
    public void updateRole(CRole role, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchRoleException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.updateRole(role, context);
    }

    @Override
    public void updateUser(CUser user) throws InvalidConfigurationException, UserNotFoundException {
        HashSet<String> roles = new HashSet<String>();
        try {
            CUserRoleMapping userRoleMapping = this.readUserRoleMapping(user.getId(), "default");
            roles.addAll(userRoleMapping.getRoles());
        }
        catch (NoSuchRoleMappingException e) {
            this.log.debug("User: {} has no roles", (Object)user.getId());
        }
        this.updateUser(user, new HashSet<String>(roles));
    }

    @Override
    public void updateUser(CUser user, Set<String> roles) throws InvalidConfigurationException, UserNotFoundException {
        this.manager.updateUser(user, roles, this.initializeContext());
    }

    @Override
    public void updateUser(CUser user, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException, UserNotFoundException {
        if (context == null) {
            context = this.initializeContext();
        }
        this.manager.updateUser(user, roles, context);
    }

    @Override
    public List<PrivilegeDescriptor> listPrivilegeDescriptors() {
        return this.manager.listPrivilegeDescriptors();
    }

    @Override
    public void cleanRemovedPrivilege(String privilegeId) {
        this.manager.cleanRemovedPrivilege(privilegeId);
    }

    @Override
    public void cleanRemovedRole(String roleId) {
        this.manager.cleanRemovedRole(roleId);
    }

    @Override
    public void save() {
        this.manager.save();
    }

    @Override
    protected boolean shouldRebuildConfiguration() {
        for (DynamicSecurityResource resource : this.dynamicResources) {
            if (!resource.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Configuration doGetConfiguration() {
        Configuration resConfig;
        Configuration configuration = new Configuration();
        for (StaticSecurityResource staticSecurityResource : this.staticResources) {
            resConfig = staticSecurityResource.getConfiguration();
            if (resConfig == null) continue;
            this.appendConfig(configuration, resConfig);
        }
        for (DynamicSecurityResource dynamicSecurityResource : this.dynamicResources) {
            resConfig = dynamicSecurityResource.getConfiguration();
            if (resConfig == null) continue;
            this.appendConfig(configuration, resConfig);
        }
        return configuration;
    }

    private Configuration appendConfig(Configuration configuration, Configuration config) {
        for (CPrivilege cPrivilege : config.getPrivileges()) {
            configuration.addPrivilege(cPrivilege);
        }
        HashMap<String, CRole> roles = new HashMap<String, CRole>();
        for (CRole role : configuration.getRoles()) {
            roles.put(role.getId(), role);
        }
        for (CRole role : config.getRoles()) {
            CRole eachRole = (CRole)roles.get(role.getId());
            if (eachRole != null) {
                role = this.mergeRolesContents(role, eachRole);
                configuration.removeRole(eachRole);
            }
            configuration.addRole(role);
            roles.put(role.getId(), role);
        }
        for (CUser user : config.getUsers()) {
            configuration.addUser(user);
        }
        return configuration;
    }
}

