/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.model.Configuration;

public class EnhancedConfiguration {
    private final Configuration delegate;
    private final ConcurrentHashMap<String, CUser> id2users = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CRole> id2roles = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CPrivilege> id2privileges = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CUserRoleMapping> id2roleMappings = new ConcurrentHashMap();

    public EnhancedConfiguration(Configuration configuration) {
        this.delegate = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.rebuildId2UsersLookupMap();
        this.rebuildId2RolesLookupMap();
        this.rebuildId2PrivilegesLookupMap();
        this.rebuildId2RoleMappingsLookupMap();
    }

    public void addPrivilege(CPrivilege cPrivilege) {
        CPrivilege cp = cPrivilege.clone();
        this.delegate.addPrivilege(cp);
        this.id2privileges.put(cp.getId(), cp);
    }

    public void addRole(CRole cRole) {
        CRole cr = cRole.clone();
        this.delegate.addRole(cr);
        this.id2roles.put(cr.getId(), cr);
    }

    public void addUser(CUser cUser) {
        CUser cu = cUser.clone();
        this.delegate.addUser(cu);
        this.id2users.put(cu.getId(), cu);
    }

    public void addUserRoleMapping(CUserRoleMapping cUserRoleMapping) {
        CUserRoleMapping curm = cUserRoleMapping.clone();
        this.delegate.addUserRoleMapping(curm);
        this.id2roleMappings.put(this.getUserRoleMappingKey(curm.getUserId(), curm.getSource()), curm);
    }

    public List<CPrivilege> getPrivileges() {
        return ImmutableList.copyOf(this.delegate.getPrivileges());
    }

    public List<CRole> getRoles() {
        return ImmutableList.copyOf(this.delegate.getRoles());
    }

    public List<CUserRoleMapping> getUserRoleMappings() {
        return ImmutableList.copyOf(this.delegate.getUserRoleMappings());
    }

    public List<CUser> getUsers() {
        return ImmutableList.copyOf(this.delegate.getUsers());
    }

    public void removePrivilege(CPrivilege cPrivilege) {
        this.id2privileges.remove(cPrivilege.getId());
        this.delegate.removePrivilege(cPrivilege);
    }

    public void removeRole(CRole cRole) {
        this.id2roles.remove(cRole.getId());
        this.delegate.removeRole(cRole);
    }

    public void removeUser(CUser cUser) {
        this.id2users.remove(cUser.getId());
        this.delegate.removeUser(cUser);
    }

    public void removeUserRoleMapping(CUserRoleMapping cUserRoleMapping) {
        this.id2roleMappings.remove(this.getUserRoleMappingKey(cUserRoleMapping.getUserId(), cUserRoleMapping.getSource()));
        this.delegate.removeUserRoleMapping(cUserRoleMapping);
    }

    public void setPrivileges(List<CPrivilege> privileges) {
        this.delegate.setPrivileges(privileges);
        this.rebuildId2PrivilegesLookupMap();
    }

    public void setRoles(List<CRole> roles) {
        this.delegate.setRoles(roles);
        this.rebuildId2RolesLookupMap();
    }

    public void setUserRoleMappings(List<CUserRoleMapping> userRoleMappings) {
        this.delegate.setUserRoleMappings(userRoleMappings);
        this.rebuildId2RoleMappingsLookupMap();
    }

    public void setUsers(List<CUser> users) {
        this.delegate.setUsers(users);
        this.rebuildId2UsersLookupMap();
    }

    public CUser getUserById(String id) {
        return this.getUserById(id, true);
    }

    public CUser getUserById(String id, boolean clone) {
        CUser user = this.id2users.get(id);
        if (user != null) {
            return clone ? user.clone() : user;
        }
        return null;
    }

    public boolean removeUserById(String id) {
        CUser user = this.getUserById(id, false);
        if (user != null) {
            this.delegate.removeUser(user);
            return this.id2users.remove(id) != null;
        }
        return false;
    }

    public CRole getRoleById(String id) {
        return this.getRoleById(id, true);
    }

    public CRole getRoleById(String id, boolean clone) {
        CRole role = this.id2roles.get(id);
        if (role != null) {
            return clone ? role.clone() : role;
        }
        return null;
    }

    public boolean removeRoleById(String id) {
        CRole role = this.getRoleById(id, false);
        if (role != null) {
            this.delegate.removeRole(role);
            return this.id2roles.remove(id) != null;
        }
        return false;
    }

    public CPrivilege getPrivilegeById(String id) {
        return this.getPrivilegeById(id, true);
    }

    public CPrivilege getPrivilegeById(String id, boolean clone) {
        CPrivilege privilege = this.id2privileges.get(id);
        if (privilege != null) {
            return clone ? privilege.clone() : privilege;
        }
        return null;
    }

    public boolean removePrivilegeById(String id) {
        CPrivilege privilege = this.getPrivilegeById(id, false);
        if (privilege != null) {
            this.delegate.removePrivilege(privilege);
            return this.id2privileges.remove(id) != null;
        }
        return false;
    }

    public CUserRoleMapping getUserRoleMappingByUserId(String id, String source) {
        return this.getUserRoleMappingByUserId(id, source, true);
    }

    public CUserRoleMapping getUserRoleMappingByUserId(String id, String source, boolean clone) {
        CUserRoleMapping mapping = this.id2roleMappings.get(this.getUserRoleMappingKey(id, source));
        if (mapping != null) {
            return clone ? mapping.clone() : mapping;
        }
        return null;
    }

    public boolean removeUserRoleMappingByUserId(String id, String source) {
        CUserRoleMapping mapping = this.getUserRoleMappingByUserId(id, source, false);
        if (mapping != null) {
            this.delegate.removeUserRoleMapping(mapping);
            return this.id2roleMappings.remove(this.getUserRoleMappingKey(id, source)) != null;
        }
        return false;
    }

    public String toString() {
        return super.toString() + " delegating to " + this.delegate.toString();
    }

    protected void rebuildId2UsersLookupMap() {
        this.id2users.clear();
        for (CUser user : this.delegate.getUsers()) {
            this.id2users.put(user.getId(), user);
        }
    }

    protected void rebuildId2RolesLookupMap() {
        this.id2roles.clear();
        for (CRole role : this.delegate.getRoles()) {
            this.id2roles.put(role.getId(), role);
        }
    }

    protected void rebuildId2PrivilegesLookupMap() {
        this.id2privileges.clear();
        for (CPrivilege privilege : this.delegate.getPrivileges()) {
            this.id2privileges.put(privilege.getId(), privilege);
        }
    }

    protected void rebuildId2RoleMappingsLookupMap() {
        this.id2roleMappings.clear();
        for (CUserRoleMapping user2role : this.delegate.getUserRoleMappings()) {
            this.id2roleMappings.put(this.getUserRoleMappingKey(user2role.getUserId(), user2role.getSource()), user2role);
        }
    }

    protected String getUserRoleMappingKey(String userId, String source) {
        return userId.toLowerCase() + "|" + source;
    }
}

