/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.HashingPasswordService;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashService;
import org.sonatype.security.configuration.SecurityConfigurationManager;

@Singleton
@Typed(value={PasswordService.class})
@Named(value="default")
public class DefaultSecurityPasswordService
implements HashingPasswordService {
    private static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    private final SecurityConfigurationManager securityConfiguration;
    private final DefaultPasswordService passwordService;
    private final PasswordService legacyPasswordService;

    @Inject
    public DefaultSecurityPasswordService(SecurityConfigurationManager securityConfiguration, @Named(value="legacy") PasswordService legacyPasswordService) {
        this.securityConfiguration = securityConfiguration;
        this.passwordService = new DefaultPasswordService();
        this.legacyPasswordService = legacyPasswordService;
        DefaultHashService hashService = new DefaultHashService();
        hashService.setHashAlgorithmName(DEFAULT_HASH_ALGORITHM);
        hashService.setHashIterations(this.securityConfiguration.getHashIterations());
        hashService.setGeneratePublicSalt(true);
        this.passwordService.setHashService((HashService)hashService);
    }

    public String encryptPassword(Object plaintextPassword) throws IllegalArgumentException {
        return this.passwordService.encryptPassword(plaintextPassword);
    }

    public boolean passwordsMatch(Object submittedPlaintext, String encrypted) {
        if (this.passwordService.passwordsMatch(submittedPlaintext, encrypted)) {
            return true;
        }
        return this.legacyPasswordService.passwordsMatch(submittedPlaintext, encrypted);
    }

    public Hash hashPassword(Object plaintext) throws IllegalArgumentException {
        return this.passwordService.hashPassword(plaintext);
    }

    public boolean passwordsMatch(Object plaintext, Hash savedPasswordHash) {
        return this.passwordService.passwordsMatch(plaintext, savedPasswordHash);
    }
}

