/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.realms.tools.EnhancedConfiguration;
import org.sonatype.security.realms.tools.SecurityConfigurationCleaner;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={SecurityConfigurationCleaner.class})
@Named(value="default")
public class DefaultSecurityConfigurationCleaner
extends ComponentSupport
implements SecurityConfigurationCleaner {
    @Override
    public void privilegeRemoved(EnhancedConfiguration configuration, String privilegeId) {
        this.log.debug("Cleaning privilege id {} from roles.", (Object)privilegeId);
        List<CRole> roles = configuration.getRoles();
        for (CRole role : roles) {
            if (!role.getPrivileges().contains(privilegeId)) continue;
            this.log.debug("removing privilege {} from role {}", (Object)privilegeId, (Object)role.getId());
            role.getPrivileges().remove(privilegeId);
            configuration.removeRoleById(role.getId());
            configuration.addRole(role);
        }
    }

    @Override
    public void roleRemoved(EnhancedConfiguration configuration, String roleId) {
        this.log.debug("Cleaning role id {} from users and roles.", (Object)roleId);
        List<CRole> roles = configuration.getRoles();
        for (CRole role : roles) {
            if (!role.getRoles().contains(roleId)) continue;
            this.log.debug("removing ref to role {} from role {}", (Object)roleId, (Object)role.getId());
            role.getRoles().remove(roleId);
            configuration.removeRoleById(role.getId());
            configuration.addRole(role);
        }
        List<CUserRoleMapping> mappings = configuration.getUserRoleMappings();
        for (CUserRoleMapping mapping : mappings) {
            if (!mapping.getRoles().contains(roleId)) continue;
            this.log.debug("removing ref to role {} from user {}", (Object)mapping.getUserId());
            mapping.removeRole(roleId);
            configuration.removeUserRoleMappingByUserId(mapping.getUserId(), mapping.getSource());
            configuration.addUserRoleMapping(mapping);
        }
    }
}

