/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.credential.PasswordService;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CProperty;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.source.SecurityModelConfigurationSource;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.tools.AbstractConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.realms.tools.NoSuchRoleMappingException;
import org.sonatype.security.realms.tools.SecurityConfigurationCleaner;
import org.sonatype.security.realms.tools.SecurityConfigurationModifier;
import org.sonatype.security.realms.validator.SecurityConfigurationValidator;
import org.sonatype.security.realms.validator.SecurityValidationContext;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Typed(value={ConfigurationManager.class})
@Named(value="legacydefault")
public class DefaultConfigurationManager
extends AbstractConfigurationManager {
    private final SecurityModelConfigurationSource configurationSource;
    private final SecurityConfigurationValidator validator;
    private final List<PrivilegeDescriptor> privilegeDescriptors;
    private final SecurityConfigurationCleaner configCleaner;
    private final List<SecurityConfigurationModifier> configurationModifiers;
    private final PasswordService passwordService;

    @Inject
    public DefaultConfigurationManager(EventBus eventBus, List<SecurityConfigurationModifier> configurationModifiers, SecurityConfigurationCleaner configCleaner, SecurityConfigurationValidator validator, @Named(value="file") SecurityModelConfigurationSource configurationSource, List<PrivilegeDescriptor> privilegeDescriptors, PasswordService passwordService) {
        super(eventBus);
        this.configurationModifiers = configurationModifiers;
        this.configCleaner = configCleaner;
        this.validator = validator;
        this.configurationSource = configurationSource;
        this.privilegeDescriptors = privilegeDescriptors;
        this.passwordService = passwordService;
    }

    @Override
    public void runRead(ConfigurationManagerAction action) throws Exception {
        throw new UnsupportedOperationException("Concurrent access not supported. ConcurrentConfigurationManager should be used instead");
    }

    @Override
    public void runWrite(ConfigurationManagerAction action) throws Exception {
        throw new UnsupportedOperationException("Concurrent access not supported. ConcurrentConfigurationManager should be used instead");
    }

    @Override
    public List<CPrivilege> listPrivileges() {
        return Collections.unmodifiableList(this.getConfiguration().getPrivileges());
    }

    @Override
    public List<CRole> listRoles() {
        return Collections.unmodifiableList(this.getConfiguration().getRoles());
    }

    @Override
    public List<CUser> listUsers() {
        return Collections.unmodifiableList(this.getConfiguration().getUsers());
    }

    @Override
    public void createPrivilege(CPrivilege privilege) throws InvalidConfigurationException {
        this.createPrivilege(privilege, this.initializeContext());
    }

    @Override
    public void createPrivilege(CPrivilege privilege, SecurityValidationContext context) throws InvalidConfigurationException {
        ValidationResponse vr;
        if (context == null) {
            context = this.initializeContext();
        }
        if (!(vr = this.validator.validatePrivilege(context, privilege, false)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.getConfiguration().addPrivilege(privilege);
        this.logValidationWarnings(vr);
    }

    @Override
    public void createRole(CRole role) throws InvalidConfigurationException {
        this.createRole(role, this.initializeContext());
    }

    @Override
    public void createRole(CRole role, SecurityValidationContext context) throws InvalidConfigurationException {
        ValidationResponse vr;
        if (context == null) {
            context = this.initializeContext();
        }
        if (!(vr = this.validator.validateRole(context, role, false)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.getConfiguration().addRole(role);
        this.logValidationWarnings(vr);
    }

    @Override
    public void createUser(CUser user, Set<String> roles) throws InvalidConfigurationException {
        this.createUser(user, null, roles, this.initializeContext());
    }

    @Override
    public void createUser(CUser user, String password, Set<String> roles) throws InvalidConfigurationException {
        this.createUser(user, password, roles, this.initializeContext());
    }

    @Override
    public void createUser(CUser user, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException {
        this.createUser(user, null, roles, context);
    }

    @Override
    public void createUser(CUser user, String password, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException {
        ValidationResponse vr;
        if (context == null) {
            context = this.initializeContext();
        }
        if (password != null && password.trim().length() > 0) {
            user.setPassword(this.passwordService.encryptPassword((Object)password));
        }
        if (!(vr = this.validator.validateUser(context, user, roles, false)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.getConfiguration().addUser(user);
        this.createOrUpdateUserRoleMapping(this.buildUserRoleMapping(user.getId(), roles));
        this.logValidationWarnings(vr);
    }

    private void createOrUpdateUserRoleMapping(CUserRoleMapping roleMapping) {
        try {
            this.deleteUserRoleMapping(roleMapping.getUserId(), roleMapping.getSource());
        }
        catch (NoSuchRoleMappingException noSuchRoleMappingException) {
            // empty catch block
        }
        this.getConfiguration().addUserRoleMapping(roleMapping);
    }

    private CUserRoleMapping buildUserRoleMapping(String userId, Set<String> roles) {
        CUserRoleMapping roleMapping = new CUserRoleMapping();
        roleMapping.setUserId(userId);
        roleMapping.setSource("default");
        roleMapping.setRoles(new ArrayList<String>(roles));
        return roleMapping;
    }

    @Override
    public void deletePrivilege(String id) throws NoSuchPrivilegeException {
        this.deletePrivilege(id, true);
    }

    public void deletePrivilege(String id, boolean clean) throws NoSuchPrivilegeException {
        boolean found = this.getConfiguration().removePrivilegeById(id);
        if (!found) {
            throw new NoSuchPrivilegeException(id);
        }
        if (clean) {
            this.cleanRemovedPrivilege(id);
        }
    }

    @Override
    public void deleteRole(String id) throws NoSuchRoleException {
        this.deleteRole(id, true);
    }

    protected void deleteRole(String id, boolean clean) throws NoSuchRoleException {
        boolean found = this.getConfiguration().removeRoleById(id);
        if (!found) {
            throw new NoSuchRoleException(id);
        }
        if (clean) {
            this.cleanRemovedRole(id);
        }
    }

    @Override
    public void deleteUser(String id) throws UserNotFoundException {
        boolean found = this.getConfiguration().removeUserById(id);
        if (!found) {
            throw new UserNotFoundException(id);
        }
        try {
            this.deleteUserRoleMapping(id, "default");
        }
        catch (NoSuchRoleMappingException e) {
            this.log.debug("User role mapping for user: " + id + " source: " + "default" + " could not be deleted because it does not exist.");
        }
    }

    @Override
    public CPrivilege readPrivilege(String id) throws NoSuchPrivilegeException {
        CPrivilege privilege = this.getConfiguration().getPrivilegeById(id);
        if (privilege != null) {
            return privilege;
        }
        throw new NoSuchPrivilegeException(id);
    }

    @Override
    public CRole readRole(String id) throws NoSuchRoleException {
        CRole role = this.getConfiguration().getRoleById(id);
        if (role != null) {
            return role;
        }
        throw new NoSuchRoleException(id);
    }

    @Override
    public CUser readUser(String id) throws UserNotFoundException {
        CUser user = this.getConfiguration().getUserById(id);
        if (user != null) {
            return user;
        }
        throw new UserNotFoundException(id);
    }

    @Override
    public void updatePrivilege(CPrivilege privilege) throws InvalidConfigurationException, NoSuchPrivilegeException {
        this.updatePrivilege(privilege, this.initializeContext());
    }

    @Override
    public void updatePrivilege(CPrivilege privilege, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchPrivilegeException {
        ValidationResponse vr;
        if (context == null) {
            context = this.initializeContext();
        }
        if (!(vr = this.validator.validatePrivilege(context, privilege, true)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.deletePrivilege(privilege.getId(), false);
        this.getConfiguration().addPrivilege(privilege);
        this.logValidationWarnings(vr);
    }

    @Override
    public void updateRole(CRole role) throws InvalidConfigurationException, NoSuchRoleException {
        this.updateRole(role, this.initializeContext());
    }

    @Override
    public void updateRole(CRole role, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchRoleException {
        ValidationResponse vr;
        if (context == null) {
            context = this.initializeContext();
        }
        if (!(vr = this.validator.validateRole(context, role, true)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.deleteRole(role.getId(), false);
        this.getConfiguration().addRole(role);
        this.logValidationWarnings(vr);
    }

    @Override
    public void updateUser(CUser user) throws InvalidConfigurationException, UserNotFoundException {
        HashSet roles = Sets.newHashSet();
        try {
            CUserRoleMapping userRoleMapping = this.readUserRoleMapping(user.getId(), "default");
            roles.addAll(userRoleMapping.getRoles());
        }
        catch (NoSuchRoleMappingException e) {
            this.log.debug("User: {} has no roles", (Object)user.getId());
        }
        this.updateUser(user, new HashSet<String>(roles));
    }

    @Override
    public void updateUser(CUser user, Set<String> roles) throws InvalidConfigurationException, UserNotFoundException {
        this.updateUser(user, roles, this.initializeContext());
    }

    @Override
    public void updateUser(CUser user, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException, UserNotFoundException {
        ValidationResponse vr;
        if (context == null) {
            context = this.initializeContext();
        }
        if (!(vr = this.validator.validateUser(context, user, roles, true)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.deleteUser(user.getId());
        this.getConfiguration().addUser(user);
        this.createOrUpdateUserRoleMapping(this.buildUserRoleMapping(user.getId(), roles));
        this.logValidationWarnings(vr);
    }

    @Override
    public String getPrivilegeProperty(CPrivilege privilege, String key) {
        if (privilege != null && privilege.getProperties() != null) {
            for (CProperty prop : privilege.getProperties()) {
                if (!prop.getKey().equals(key)) continue;
                return prop.getValue();
            }
        }
        return null;
    }

    @Override
    public void createUserRoleMapping(CUserRoleMapping userRoleMapping) throws InvalidConfigurationException {
        this.createUserRoleMapping(userRoleMapping, this.initializeContext());
    }

    @Override
    public void createUserRoleMapping(CUserRoleMapping userRoleMapping, SecurityValidationContext context) throws InvalidConfigurationException {
        if (context == null) {
            context = this.initializeContext();
        }
        try {
            this.readUserRoleMapping(userRoleMapping.getUserId(), userRoleMapping.getSource());
            ValidationResponse vr = new ValidationResponse();
            vr.addValidationError(new ValidationMessage("*", "User Role Mapping for user '" + userRoleMapping.getUserId() + "' already exists."));
            throw new InvalidConfigurationException(vr);
        }
        catch (NoSuchRoleMappingException vr) {
            ValidationResponse vr2 = this.validator.validateUserRoleMapping(context, userRoleMapping, false);
            if (vr2.getValidationErrors().size() > 0) {
                throw new InvalidConfigurationException(vr2);
            }
            this.getConfiguration().addUserRoleMapping(userRoleMapping);
            this.logValidationWarnings(vr2);
            return;
        }
    }

    private void logValidationWarnings(ValidationResponse vr) {
        List validationWarnings = vr.getValidationWarnings();
        if (validationWarnings != null && validationWarnings.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ValidationMessage msg : validationWarnings) {
                if (sb.length() >= 0) {
                    sb.append(",");
                }
                sb.append(" ").append(msg.toString());
            }
            this.log.warn("Security configuration has validation warnings:" + sb.toString());
        }
    }

    private CUserRoleMapping readCUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        CUserRoleMapping mapping = this.getConfiguration().getUserRoleMappingByUserId(userId, source);
        if (mapping != null) {
            return mapping;
        }
        throw new NoSuchRoleMappingException("No User Role Mapping for user: " + userId);
    }

    @Override
    public CUserRoleMapping readUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        return this.readCUserRoleMapping(userId, source);
    }

    @Override
    public void updateUserRoleMapping(CUserRoleMapping userRoleMapping) throws InvalidConfigurationException, NoSuchRoleMappingException {
        this.updateUserRoleMapping(userRoleMapping, this.initializeContext());
    }

    @Override
    public void updateUserRoleMapping(CUserRoleMapping userRoleMapping, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchRoleMappingException {
        if (context == null) {
            context = this.initializeContext();
        }
        if (this.readUserRoleMapping(userRoleMapping.getUserId(), userRoleMapping.getSource()) == null) {
            ValidationResponse vr = new ValidationResponse();
            vr.addValidationError(new ValidationMessage("*", "No User Role Mapping found for user '" + userRoleMapping.getUserId() + "'."));
            throw new InvalidConfigurationException(vr);
        }
        ValidationResponse vr = this.validator.validateUserRoleMapping(context, userRoleMapping, true);
        if (vr.getValidationErrors().size() > 0) {
            throw new InvalidConfigurationException(vr);
        }
        this.deleteUserRoleMapping(userRoleMapping.getUserId(), userRoleMapping.getSource());
        this.getConfiguration().addUserRoleMapping(userRoleMapping);
    }

    @Override
    public List<CUserRoleMapping> listUserRoleMappings() {
        return Collections.unmodifiableList(this.getConfiguration().getUserRoleMappings());
    }

    @Override
    public void deleteUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        boolean found = this.getConfiguration().removeUserRoleMappingByUserId(userId, source);
        if (!found) {
            throw new NoSuchRoleMappingException("No User Role Mapping for user: " + userId);
        }
    }

    @Override
    public String getPrivilegeProperty(String id, String key) throws NoSuchPrivilegeException {
        return this.getPrivilegeProperty(this.readPrivilege(id), key);
    }

    @Override
    public void save() {
        try {
            this.configurationSource.storeConfiguration();
        }
        catch (IOException e) {
            this.log.error("IOException while storing configuration file", (Throwable)e);
        }
    }

    @Override
    protected synchronized Configuration doGetConfiguration() {
        try {
            this.configurationSource.loadConfiguration();
            boolean modified = false;
            for (SecurityConfigurationModifier modifier : this.configurationModifiers) {
                modified |= modifier.apply((Configuration)this.configurationSource.getConfiguration());
            }
            if (modified) {
                this.configurationSource.backupConfiguration();
                this.configurationSource.storeConfiguration();
            }
            return (Configuration)this.configurationSource.getConfiguration();
        }
        catch (IOException e) {
            this.log.error("IOException while retrieving configuration file", (Throwable)e);
            throw new IllegalStateException("Cannot load configuration!", e);
        }
        catch (ConfigurationException e) {
            this.log.error("Invalid Configuration", (Throwable)e);
            throw new IllegalStateException("Invalid configuration!", e);
        }
    }

    @Override
    public SecurityValidationContext initializeContext() {
        SecurityValidationContext context = new SecurityValidationContext();
        context.addExistingUserIds();
        context.addExistingRoleIds();
        context.addExistingPrivilegeIds();
        for (CUser user : this.listUsers()) {
            context.getExistingUserIds().add(user.getId());
            context.getExistingEmailMap().put(user.getId(), user.getEmail());
        }
        for (CRole role : this.listRoles()) {
            context.getExistingRoleIds().add(role.getId());
            ArrayList<String> containedRoles = new ArrayList<String>();
            containedRoles.addAll(role.getRoles());
            context.getRoleContainmentMap().put(role.getId(), containedRoles);
            context.getExistingRoleNameMap().put(role.getId(), role.getName());
        }
        for (CPrivilege priv : this.listPrivileges()) {
            context.getExistingPrivilegeIds().add(priv.getId());
        }
        for (CUserRoleMapping roleMappings : this.listUserRoleMappings()) {
            context.getExistingUserRoleMap().put(roleMappings.getUserId(), roleMappings.getRoles());
        }
        return context;
    }

    @Override
    public List<PrivilegeDescriptor> listPrivilegeDescriptors() {
        return Collections.unmodifiableList(this.privilegeDescriptors);
    }

    @Override
    public void cleanRemovedPrivilege(String privilegeId) {
        this.configCleaner.privilegeRemoved(this.getConfiguration(), privilegeId);
    }

    @Override
    public void cleanRemovedRole(String roleId) {
        this.configCleaner.roleRemoved(this.getConfiguration(), roleId);
    }
}

