/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.realms.tools.NoSuchRoleMappingException;
import org.sonatype.security.realms.validator.SecurityValidationContext;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={ConfigurationManager.class})
@Named(value="default")
public class DefaultConcurrentConfigurationManager
extends ComponentSupport
implements ConfigurationManager {
    private final ConfigurationManager configurationManager;
    private final ReentrantReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;
    private final long lockTimeout;

    @Inject
    public DefaultConcurrentConfigurationManager(@Named(value="resourceMerging") ConfigurationManager configurationManager, @Named(value="${security.configmgr.locktimeout:-60}") long lockTimeout) {
        this.configurationManager = configurationManager;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.lockTimeout = lockTimeout;
        this.log.debug("Lock timeout: {} seconds", (Object)lockTimeout);
    }

    @Override
    public void runRead(ConfigurationManagerAction action) throws Exception {
        this.acquireLock(this.readLock);
        try {
            action.run();
        }
        finally {
            this.releaseLock(this.readLock);
        }
    }

    @Override
    public void runWrite(ConfigurationManagerAction action) throws Exception {
        this.acquireLock(this.writeLock);
        try {
            action.run();
        }
        finally {
            this.releaseLock(this.writeLock);
        }
    }

    @Override
    public void deleteUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        this.checkWriteLock();
        this.configurationManager.deleteUserRoleMapping(userId, source);
    }

    @Override
    public void deleteUser(String id) throws UserNotFoundException {
        this.checkWriteLock();
        this.configurationManager.deleteUser(id);
    }

    @Override
    public void deleteRole(String id) throws NoSuchRoleException {
        this.checkWriteLock();
        this.configurationManager.deleteRole(id);
    }

    @Override
    public void deletePrivilege(String id) throws NoSuchPrivilegeException {
        this.checkWriteLock();
        this.configurationManager.deletePrivilege(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrivilegeProperty(String id, String key) throws NoSuchPrivilegeException {
        this.readLock.lock();
        try {
            String string = this.configurationManager.getPrivilegeProperty(id, key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clearCache() {
        this.checkWriteLock();
        this.configurationManager.clearCache();
    }

    @Override
    public void save() {
        this.checkWriteLock();
        this.configurationManager.save();
    }

    @Override
    public void cleanRemovedRole(String roleId) {
        this.checkWriteLock();
        this.configurationManager.cleanRemovedRole(roleId);
    }

    @Override
    public void cleanRemovedPrivilege(String privilegeId) {
        this.checkWriteLock();
        this.configurationManager.cleanRemovedPrivilege(privilegeId);
    }

    @Override
    public List<CUser> listUsers() {
        this.readLock.lock();
        try {
            List<CUser> list = this.configurationManager.listUsers();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<CRole> listRoles() {
        this.readLock.lock();
        try {
            List<CRole> list = this.configurationManager.listRoles();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<CPrivilege> listPrivileges() {
        this.readLock.lock();
        try {
            List<CPrivilege> list = this.configurationManager.listPrivileges();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<PrivilegeDescriptor> listPrivilegeDescriptors() {
        this.readLock.lock();
        try {
            List<PrivilegeDescriptor> list = this.configurationManager.listPrivilegeDescriptors();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void createUser(CUser user, Set<String> roles) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createUser(user, roles);
    }

    @Override
    public void createUser(CUser user, String password, Set<String> roles) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createUser(user, password, roles);
    }

    @Override
    public void createUser(CUser user, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createUser(user, roles, context);
    }

    @Override
    public void createUser(CUser user, String password, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createUser(user, password, roles, context);
    }

    @Override
    public void createRole(CRole role) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createRole(role);
    }

    @Override
    public void createRole(CRole role, SecurityValidationContext context) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createRole(role, context);
    }

    @Override
    public void createPrivilege(CPrivilege privilege) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createPrivilege(privilege);
    }

    @Override
    public void createPrivilege(CPrivilege privilege, SecurityValidationContext context) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createPrivilege(privilege, context);
    }

    @Override
    public CUser readUser(String id) throws UserNotFoundException {
        this.readLock.lock();
        try {
            CUser cUser = this.configurationManager.readUser(id);
            return cUser;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public CRole readRole(String id) throws NoSuchRoleException {
        this.readLock.lock();
        try {
            CRole cRole = this.configurationManager.readRole(id);
            return cRole;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public CPrivilege readPrivilege(String id) throws NoSuchPrivilegeException {
        this.readLock.lock();
        try {
            CPrivilege cPrivilege = this.configurationManager.readPrivilege(id);
            return cPrivilege;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void updateUser(CUser user) throws InvalidConfigurationException, UserNotFoundException {
        this.checkWriteLock();
        this.configurationManager.updateUser(user);
    }

    @Override
    public void updateUser(CUser user, Set<String> roles) throws InvalidConfigurationException, UserNotFoundException {
        this.checkWriteLock();
        this.configurationManager.updateUser(user, roles);
    }

    @Override
    public void updateUser(CUser user, Set<String> roles, SecurityValidationContext context) throws InvalidConfigurationException, UserNotFoundException {
        this.checkWriteLock();
        this.configurationManager.updateUser(user, roles, context);
    }

    @Override
    public void updateRole(CRole role) throws InvalidConfigurationException, NoSuchRoleException {
        this.checkWriteLock();
        this.configurationManager.updateRole(role);
    }

    @Override
    public void updateRole(CRole role, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchRoleException {
        this.checkWriteLock();
        this.configurationManager.updateRole(role, context);
    }

    @Override
    public void createUserRoleMapping(CUserRoleMapping userRoleMapping) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createUserRoleMapping(userRoleMapping);
    }

    @Override
    public void createUserRoleMapping(CUserRoleMapping userRoleMapping, SecurityValidationContext context) throws InvalidConfigurationException {
        this.checkWriteLock();
        this.configurationManager.createUserRoleMapping(userRoleMapping, context);
    }

    @Override
    public void updateUserRoleMapping(CUserRoleMapping userRoleMapping) throws InvalidConfigurationException, NoSuchRoleMappingException {
        this.checkWriteLock();
        this.configurationManager.updateUserRoleMapping(userRoleMapping);
    }

    @Override
    public void updateUserRoleMapping(CUserRoleMapping userRoleMapping, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchRoleMappingException {
        this.checkWriteLock();
        this.configurationManager.updateUserRoleMapping(userRoleMapping, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CUserRoleMapping readUserRoleMapping(String userId, String source) throws NoSuchRoleMappingException {
        this.readLock.lock();
        try {
            CUserRoleMapping cUserRoleMapping = this.configurationManager.readUserRoleMapping(userId, source);
            return cUserRoleMapping;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<CUserRoleMapping> listUserRoleMappings() {
        this.readLock.lock();
        try {
            List<CUserRoleMapping> list = this.configurationManager.listUserRoleMappings();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void updatePrivilege(CPrivilege privilege) throws InvalidConfigurationException, NoSuchPrivilegeException {
        this.checkWriteLock();
        this.configurationManager.updatePrivilege(privilege);
    }

    @Override
    public void updatePrivilege(CPrivilege privilege, SecurityValidationContext context) throws InvalidConfigurationException, NoSuchPrivilegeException {
        this.checkWriteLock();
        this.configurationManager.updatePrivilege(privilege, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrivilegeProperty(CPrivilege privilege, String key) {
        this.readLock.lock();
        try {
            String string = this.configurationManager.getPrivilegeProperty(privilege, key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public SecurityValidationContext initializeContext() {
        this.readLock.lock();
        try {
            SecurityValidationContext securityValidationContext = this.configurationManager.initializeContext();
            return securityValidationContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void acquireLock(Lock lock) {
        try {
            if (!lock.tryLock(this.lockTimeout, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Unable to acquire lock");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unable to acquire lock", e);
        }
    }

    private void releaseLock(Lock lock) {
        lock.unlock();
    }

    private void checkWriteLock() {
        if (this.readWriteLock.getWriteHoldCount() == 0) {
            throw new IllegalStateException("Method called without proper locking");
        }
    }
}

