/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import java.util.List;
import java.util.Set;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.realms.tools.NoSuchRoleMappingException;
import org.sonatype.security.realms.validator.SecurityValidationContext;
import org.sonatype.security.usermanagement.UserNotFoundException;

public interface ConfigurationManager {
    public void runRead(ConfigurationManagerAction var1) throws Exception;

    public void runWrite(ConfigurationManagerAction var1) throws Exception;

    public List<CUser> listUsers();

    public List<CRole> listRoles();

    public List<CPrivilege> listPrivileges();

    public List<PrivilegeDescriptor> listPrivilegeDescriptors();

    public void createUser(CUser var1, Set<String> var2) throws InvalidConfigurationException;

    public void createUser(CUser var1, String var2, Set<String> var3) throws InvalidConfigurationException;

    public void createUser(CUser var1, Set<String> var2, SecurityValidationContext var3) throws InvalidConfigurationException;

    public void createUser(CUser var1, String var2, Set<String> var3, SecurityValidationContext var4) throws InvalidConfigurationException;

    public void createRole(CRole var1) throws InvalidConfigurationException;

    public void createRole(CRole var1, SecurityValidationContext var2) throws InvalidConfigurationException;

    public void createPrivilege(CPrivilege var1) throws InvalidConfigurationException;

    public void createPrivilege(CPrivilege var1, SecurityValidationContext var2) throws InvalidConfigurationException;

    public CUser readUser(String var1) throws UserNotFoundException;

    public CRole readRole(String var1) throws NoSuchRoleException;

    public CPrivilege readPrivilege(String var1) throws NoSuchPrivilegeException;

    public void updateUser(CUser var1) throws InvalidConfigurationException, UserNotFoundException;

    public void updateUser(CUser var1, Set<String> var2) throws InvalidConfigurationException, UserNotFoundException;

    public void updateUser(CUser var1, Set<String> var2, SecurityValidationContext var3) throws InvalidConfigurationException, UserNotFoundException;

    public void updateRole(CRole var1) throws InvalidConfigurationException, NoSuchRoleException;

    public void updateRole(CRole var1, SecurityValidationContext var2) throws InvalidConfigurationException, NoSuchRoleException;

    public void createUserRoleMapping(CUserRoleMapping var1) throws InvalidConfigurationException;

    public void createUserRoleMapping(CUserRoleMapping var1, SecurityValidationContext var2) throws InvalidConfigurationException;

    public void updateUserRoleMapping(CUserRoleMapping var1) throws InvalidConfigurationException, NoSuchRoleMappingException;

    public void updateUserRoleMapping(CUserRoleMapping var1, SecurityValidationContext var2) throws InvalidConfigurationException, NoSuchRoleMappingException;

    public CUserRoleMapping readUserRoleMapping(String var1, String var2) throws NoSuchRoleMappingException;

    public List<CUserRoleMapping> listUserRoleMappings();

    public void deleteUserRoleMapping(String var1, String var2) throws NoSuchRoleMappingException;

    public void updatePrivilege(CPrivilege var1) throws InvalidConfigurationException, NoSuchPrivilegeException;

    public void updatePrivilege(CPrivilege var1, SecurityValidationContext var2) throws InvalidConfigurationException, NoSuchPrivilegeException;

    public void deleteUser(String var1) throws UserNotFoundException;

    public void deleteRole(String var1) throws NoSuchRoleException;

    public void deletePrivilege(String var1) throws NoSuchPrivilegeException;

    public String getPrivilegeProperty(CPrivilege var1, String var2);

    public String getPrivilegeProperty(String var1, String var2) throws NoSuchPrivilegeException;

    public void clearCache();

    public void save();

    public SecurityValidationContext initializeContext();

    public void cleanRemovedRole(String var1);

    public void cleanRemovedPrivilege(String var1);
}

