/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.tools;

import org.sonatype.security.events.AuthorizationConfigurationChanged;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.EnhancedConfiguration;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class AbstractConfigurationManager
extends ComponentSupport
implements ConfigurationManager {
    private final EventBus eventBus;
    private volatile EnhancedConfiguration configurationCache = null;

    protected AbstractConfigurationManager(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void clearCache() {
        this.configurationCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnhancedConfiguration getConfiguration() {
        EnhancedConfiguration configuration = this.configurationCache;
        if (configuration == null || this.shouldRebuildConfiguration()) {
            boolean rebuiltConfiguration = false;
            AbstractConfigurationManager abstractConfigurationManager = this;
            synchronized (abstractConfigurationManager) {
                configuration = this.configurationCache;
                if (configuration == null || this.shouldRebuildConfiguration()) {
                    rebuiltConfiguration = configuration != null;
                    this.configurationCache = configuration = new EnhancedConfiguration(this.doGetConfiguration());
                }
            }
            if (rebuiltConfiguration) {
                this.eventBus.post((Object)new AuthorizationConfigurationChanged());
            }
        }
        return configuration;
    }

    protected boolean shouldRebuildConfiguration() {
        return false;
    }

    protected abstract Configuration doGetConfiguration();
}

