/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.publickey;

import java.security.PublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.security.realms.publickey.PublicKeyRepository;

public class SimplePublicKeyRepository
implements PublicKeyRepository {
    protected final Map<Object, Set<PublicKey>> accounts = new HashMap<Object, Set<PublicKey>>();
    protected final ReentrantReadWriteLock accountsLock = new ReentrantReadWriteLock();

    @Override
    public void addPublicKey(Object principal, PublicKey publicKey) {
        HashSet<PublicKey> publicKeys = new HashSet<PublicKey>(1);
        publicKeys.add(publicKey);
        this.addPublicKeys(principal, publicKeys);
    }

    @Override
    public void addPublicKeys(Object principal, Set<PublicKey> publicKeys) {
        this.accountsLock.writeLock().lock();
        try {
            if (this.hasAccount(principal)) {
                this.accounts.get(principal).addAll(publicKeys);
            } else {
                this.accounts.put(principal, new HashSet<PublicKey>(publicKeys));
            }
        }
        finally {
            this.accountsLock.writeLock().unlock();
        }
    }

    @Override
    public void removePublicKey(Object principal, PublicKey publicKey) {
        this.accountsLock.writeLock().lock();
        try {
            if (this.hasAccount(principal)) {
                this.accounts.get(principal).remove(publicKey);
            }
        }
        finally {
            this.accountsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PublicKey> getPublicKeys(Object principal) {
        this.accountsLock.readLock().lock();
        try {
            Set<PublicKey> publicKeys = this.accounts.get(principal);
            if (publicKeys != null) {
                HashSet<PublicKey> hashSet = new HashSet<PublicKey>(publicKeys);
                return hashSet;
            }
            Set<PublicKey> set = Collections.emptySet();
            return set;
        }
        finally {
            this.accountsLock.readLock().unlock();
        }
    }

    @Override
    public boolean hasAccount(Object principal) {
        this.accountsLock.readLock().lock();
        try {
            boolean bl = this.accounts.containsKey(principal);
            return bl;
        }
        finally {
            this.accountsLock.readLock().unlock();
        }
    }
}

