/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.publickey;

import java.security.PublicKey;
import java.util.Arrays;

class PublicKeyWithEquals
implements PublicKey {
    private static final long serialVersionUID = 3668007428213640544L;
    private final PublicKey key;

    public PublicKeyWithEquals(PublicKey key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicKeyWithEquals)) {
            return false;
        }
        PublicKeyWithEquals that = (PublicKeyWithEquals)o;
        String algorithm = this.getAlgorithm();
        String thatAlgorithm = that.getAlgorithm();
        if (algorithm != null ? !algorithm.equals(thatAlgorithm) : thatAlgorithm != null) {
            return false;
        }
        if (!Arrays.equals(this.getEncoded(), that.getEncoded())) {
            return false;
        }
        String format = this.getFormat();
        String thatFormat = that.getFormat();
        return !(format != null ? !format.equals(thatFormat) : thatFormat != null);
    }

    public int hashCode() {
        String algorithm = this.getAlgorithm();
        String format = this.getFormat();
        byte[] encoded = this.getEncoded();
        int result = algorithm != null ? algorithm.hashCode() : 0;
        result = 31 * result + (format != null ? format.hashCode() : 0);
        result = 31 * result + (encoded != null ? Arrays.hashCode(encoded) : 0);
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.key.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.key.getEncoded();
    }
}

