/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.publickey;

import java.security.PublicKey;
import java.util.Collection;
import java.util.HashSet;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.sonatype.security.realms.publickey.PublicKeyAuthenticationToken;
import org.sonatype.security.realms.publickey.PublicKeyWithEquals;

class PublicKeyCredentialsMatcher
implements CredentialsMatcher {
    PublicKeyCredentialsMatcher() {
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        PublicKeyWithEquals tokenKey = this.getTokenKey(token);
        Collection<PublicKeyWithEquals> infoKeys = this.getInfoKeys(info);
        for (PublicKeyWithEquals infoKey : infoKeys) {
            if (!infoKey.equals(tokenKey)) continue;
            return true;
        }
        return false;
    }

    protected PublicKeyWithEquals getTokenKey(AuthenticationToken token) {
        PublicKeyAuthenticationToken publicKeyAuthentictionToken = (PublicKeyAuthenticationToken)token;
        return new PublicKeyWithEquals(publicKeyAuthentictionToken.getCredentials());
    }

    protected Collection<PublicKeyWithEquals> getInfoKeys(AuthenticationInfo info) {
        HashSet<PublicKeyWithEquals> result = new HashSet<PublicKeyWithEquals>();
        Object credentials = info.getCredentials();
        if (Collection.class.isAssignableFrom(credentials.getClass())) {
            Collection credentialsCollection = (Collection)credentials;
            for (PublicKey publicKey : credentialsCollection) {
                result.add(new PublicKeyWithEquals(publicKey));
            }
        } else {
            result.add(new PublicKeyWithEquals((PublicKey)credentials));
        }
        return result;
    }
}

