/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.publickey;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.security.realms.publickey.PublicKeyAuthenticationToken;
import org.sonatype.security.realms.publickey.PublicKeyCredentialsMatcher;
import org.sonatype.security.realms.publickey.PublicKeyRepository;

public class PublicKeyAuthenticatingRealm
extends AuthorizingRealm {
    protected static final Class<PublicKeyAuthenticationToken> AUTHENTICATION_TOKEN_CLASS = PublicKeyAuthenticationToken.class;
    protected PublicKeyRepository publicKeyRepository;

    public PublicKeyAuthenticatingRealm() {
        this.setAuthenticationTokenClass(AUTHENTICATION_TOKEN_CLASS);
        this.setCredentialsMatcher(new PublicKeyCredentialsMatcher());
    }

    public PublicKeyAuthenticatingRealm(PublicKeyRepository publicKeyRepository) {
        this();
        this.publicKeyRepository = publicKeyRepository;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        Object principal = token.getPrincipal();
        if (!this.publicKeyRepository.hasAccount(principal)) {
            return null;
        }
        return new SimpleAuthenticationInfo(principal, this.publicKeyRepository.getPublicKeys(principal), this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }

    public boolean supports(AuthenticationToken token) {
        return PublicKeyAuthenticationToken.class.isInstance(token);
    }

    public void setPublicKeyRepository(PublicKeyRepository publicKeyRepository) {
        this.publicKeyRepository = publicKeyRepository;
    }
}

