/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.privileges.application;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CProperty;
import org.sonatype.security.realms.privileges.AbstractPrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegePropertyDescriptor;
import org.sonatype.security.realms.validator.SecurityValidationContext;

@Singleton
@Typed(value={PrivilegeDescriptor.class})
@Named(value="ApplicationPrivilegeDescriptor")
public class ApplicationPrivilegeDescriptor
extends AbstractPrivilegeDescriptor
implements PrivilegeDescriptor {
    public static final String TYPE = "method";
    private final PrivilegePropertyDescriptor methodProperty;
    private final PrivilegePropertyDescriptor permissionProperty;

    @Inject
    public ApplicationPrivilegeDescriptor(@Named(value="ApplicationPrivilegeMethodPropertyDescriptor") PrivilegePropertyDescriptor methodProperty, @Named(value="ApplicationPrivilegePermissionPropertyDescriptor") PrivilegePropertyDescriptor permissionProperty) {
        this.methodProperty = methodProperty;
        this.permissionProperty = permissionProperty;
    }

    @Override
    public String getName() {
        return "Application";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<PrivilegePropertyDescriptor> getPropertyDescriptors() {
        ArrayList<PrivilegePropertyDescriptor> propertyDescriptors = new ArrayList<PrivilegePropertyDescriptor>();
        propertyDescriptors.add(this.methodProperty);
        propertyDescriptors.add(this.permissionProperty);
        return propertyDescriptors;
    }

    @Override
    public String buildPermission(CPrivilege privilege) {
        if (!TYPE.equals(privilege.getType())) {
            return null;
        }
        String permission = this.getProperty(privilege, "permission");
        String method = this.getProperty(privilege, TYPE);
        if (StringUtils.isEmpty((String)permission)) {
            permission = "*:*";
        }
        if (StringUtils.isEmpty((String)method)) {
            method = "*";
        }
        return permission + ":" + method;
    }

    @Override
    public ValidationResponse validatePrivilege(CPrivilege privilege, SecurityValidationContext ctx, boolean update) {
        ValidationResponse response = super.validatePrivilege(privilege, ctx, update);
        if (!TYPE.equals(privilege.getType())) {
            return response;
        }
        String method = null;
        String permission = null;
        for (CProperty property : privilege.getProperties()) {
            if (property.getKey().equals(TYPE)) {
                method = property.getValue();
                continue;
            }
            if (!property.getKey().equals("permission")) continue;
            permission = property.getValue();
        }
        if (StringUtils.isEmpty(permission)) {
            response.addValidationError("Permission cannot be empty on a privilege!");
        }
        if (StringUtils.isEmpty(method)) {
            response.addValidationError("Method cannot be empty on a privilege!");
        } else {
            String[] methods = null;
            methods = method.contains(",") ? method.split(",") : new String[]{method};
            boolean valid = true;
            for (String singlemethod : methods) {
                if ("create".equals(singlemethod) || "delete".equals(singlemethod) || "read".equals(singlemethod) || "update".equals(singlemethod) || "*".equals(singlemethod)) continue;
                valid = false;
                break;
            }
            if (!valid) {
                ValidationMessage message = new ValidationMessage(TYPE, "Privilege ID '" + privilege.getId() + "' Method is wrong! (Allowed methods are: create, delete, read and update)", "Invalid method selected.");
                response.addValidationError(message);
            }
        }
        return response;
    }
}

