/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms.privileges;

import java.util.List;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationContext;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CProperty;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.validator.ConfigurationIdGenerator;
import org.sonatype.security.realms.validator.SecurityValidationContext;

public abstract class AbstractPrivilegeDescriptor
implements PrivilegeDescriptor {
    @Inject
    private ConfigurationIdGenerator idGenerator;

    protected String getProperty(CPrivilege privilege, String key) {
        for (CProperty property : privilege.getProperties()) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    @Override
    public ValidationResponse validatePrivilege(CPrivilege privilege, SecurityValidationContext ctx, boolean update) {
        ValidationMessage message;
        SecurityValidationContext context;
        List<String> existingIds;
        ValidationResponse response = new ValidationResponse();
        if (ctx != null) {
            response.setContext((ValidationContext)ctx);
        }
        if ((existingIds = (context = (SecurityValidationContext)response.getContext()).getExistingPrivilegeIds()) == null) {
            context.addExistingPrivilegeIds();
            existingIds = context.getExistingPrivilegeIds();
        }
        if (!update && (StringUtils.isEmpty((String)privilege.getId()) || "0".equals(privilege.getId()) || existingIds.contains(privilege.getId()))) {
            String newId = this.idGenerator.generateId();
            ValidationMessage message2 = new ValidationMessage("id", "Fixed wrong privilege ID from '" + privilege.getId() + "' to '" + newId + "'");
            response.addValidationWarning(message2);
            privilege.setId(newId);
            response.setModified(true);
        }
        if (StringUtils.isEmpty((String)privilege.getType())) {
            message = new ValidationMessage("type", "Cannot have an empty type", "Privilege cannot have an invalid type");
            response.addValidationError(message);
        }
        if (StringUtils.isEmpty((String)privilege.getName())) {
            message = new ValidationMessage("name", "Privilege ID '" + privilege.getId() + "' requires a name.", "Name is required.");
            response.addValidationError(message);
        }
        return response;
    }
}

