/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms;

import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.authorization.PermissionFactory;
import org.sonatype.security.events.AuthorizationConfigurationChanged;
import org.sonatype.security.events.SecurityConfigurationChanged;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CRole;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Typed(value={RolePermissionResolver.class})
@Named(value="default")
public class XmlRolePermissionResolver
implements RolePermissionResolver {
    private final ConfigurationManager configuration;
    private final List<PrivilegeDescriptor> privilegeDescriptors;
    private final PermissionFactory permissionFactory;
    private final Map<String, Collection<Permission>> permissionsCache;

    @Inject
    public XmlRolePermissionResolver(@Named(value="default") ConfigurationManager configuration, List<PrivilegeDescriptor> privilegeDescriptors, @Named(value="caching") PermissionFactory permissionFactory, EventBus eventBus) {
        this.configuration = configuration;
        this.privilegeDescriptors = privilegeDescriptors;
        this.permissionFactory = permissionFactory;
        this.permissionsCache = new MapMaker().weakValues().makeMap();
        eventBus.register((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AuthorizationConfigurationChanged event) {
        this.permissionsCache.clear();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(SecurityConfigurationChanged event) {
        this.permissionsCache.clear();
    }

    public Collection<Permission> resolvePermissionsInRole(final String roleString) {
        try {
            final LinkedHashSet<Permission> permissions = new LinkedHashSet<Permission>();
            this.configuration.runRead(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    XmlRolePermissionResolver.this.resolvePermissionsInRole(roleString, permissions);
                }
            });
            return permissions;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void resolvePermissionsInRole(String roleString, Collection<Permission> permissions) {
        LinkedList<String> rolesToProcess = new LinkedList<String>();
        rolesToProcess.add(roleString);
        LinkedHashSet<String> processedRoleIds = new LinkedHashSet<String>();
        while (!rolesToProcess.isEmpty()) {
            String roleId = (String)rolesToProcess.removeFirst();
            if (!processedRoleIds.add(roleId)) continue;
            try {
                CRole role = this.configuration.readRole(roleId);
                Collection<Permission> cachedPermissions = this.permissionsCache.get(roleId);
                if (cachedPermissions != null) {
                    permissions.addAll(cachedPermissions);
                    continue;
                }
                rolesToProcess.addAll(role.getRoles());
                List<String> privilegeIds = role.getPrivileges();
                for (String privilegeId : privilegeIds) {
                    Set<Permission> set = this.getPermissions(privilegeId);
                    permissions.addAll(set);
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {
            }
        }
        this.permissionsCache.put(roleString, permissions);
    }

    protected Set<Permission> getPermissions(String privilegeId) {
        try {
            CPrivilege privilege = this.configuration.readPrivilege(privilegeId);
            for (PrivilegeDescriptor descriptor : this.privilegeDescriptors) {
                String permission = descriptor.buildPermission(privilege);
                if (permission == null) continue;
                return Collections.singleton(this.permissionFactory.create(permission));
            }
            return Collections.emptySet();
        }
        catch (NoSuchPrivilegeException e) {
            return Collections.emptySet();
        }
    }
}

