/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.Sha1CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.RoleMappingUserManager;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={Realm.class})
@Named(value="XmlAuthorizingRealm")
@Description(value="Xml Authorizing Realm")
public class XmlAuthorizingRealm
extends AuthorizingRealm
implements Realm {
    private static final Logger logger = LoggerFactory.getLogger(XmlAuthorizingRealm.class);
    public static final String ROLE = "XmlAuthorizingRealm";
    private final UserManager userManager;
    private final Map<String, UserManager> userManagerMap;
    private final SecuritySystem securitySystem;

    @Inject
    public XmlAuthorizingRealm(UserManager userManager, SecuritySystem securitySystem, Map<String, UserManager> userManagerMap) {
        this.userManager = userManager;
        this.securitySystem = securitySystem;
        this.userManagerMap = userManagerMap;
        this.setCredentialsMatcher((CredentialsMatcher)new Sha1CredentialsMatcher());
        this.setName(ROLE);
    }

    public boolean supports(AuthenticationToken token) {
        return false;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("Cannot authorize with no principals.");
        }
        String username = principals.getPrimaryPrincipal().toString();
        HashSet<String> roles = new HashSet<String>();
        HashSet<String> realmNames = new HashSet<String>(principals.getRealmNames());
        if (!realmNames.contains(this.getName())) {
            Iterator configureadRealms = this.securitySystem.getSecurityManager().getRealms();
            boolean foundRealm = false;
            Iterator iterator = configureadRealms.iterator();
            while (iterator.hasNext()) {
                Realm realm = (Realm)iterator.next();
                if (!realmNames.contains(realm.getName())) continue;
                foundRealm = true;
                break;
            }
            if (!foundRealm) {
                throw new AuthorizationException("User for principals: " + principals.getPrimaryPrincipal() + " belongs to a disabled realm(s): " + principals.getRealmNames() + ".");
            }
        }
        this.cleanUpRealmList(realmNames);
        if (RoleMappingUserManager.class.isInstance(this.userManager)) {
            for (String realmName : realmNames) {
                try {
                    for (RoleIdentifier roleIdentifier : ((RoleMappingUserManager)this.userManager).getUsersRoles(username, realmName)) {
                        roles.add(roleIdentifier.getRoleId());
                    }
                }
                catch (UserNotFoundException e) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Failed to find role mappings for user: " + username + " realm: " + realmName);
                }
            }
        } else if (realmNames.contains("default")) {
            try {
                for (RoleIdentifier roleIdentifier : this.userManager.getUser(username).getRoles()) {
                    roles.add(roleIdentifier.getRoleId());
                }
            }
            catch (UserNotFoundException e) {
                throw new AuthorizationException("User for principals: " + principals.getPrimaryPrincipal() + " could not be found.", (Throwable)e);
            }
        } else {
            throw new AuthorizationException("User for principals: " + principals.getPrimaryPrincipal() + " not manged by XML realm.");
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo(roles);
        return info;
    }

    private void cleanUpRealmList(Set<String> realmNames) {
        for (UserManager userManager : this.userManagerMap.values()) {
            String authRealmName = userManager.getAuthenticationRealmName();
            if (authRealmName == null || !realmNames.contains(authRealmName)) continue;
            realmNames.remove(authRealmName);
            realmNames.add(userManager.getSource());
        }
        if (realmNames.contains(this.getName())) {
            realmNames.remove(this.getName());
            realmNames.add("default");
        }
    }
}

