/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.realms;

import com.google.common.base.Throwables;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.security.model.CUser;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={Realm.class})
@Named(value="XmlAuthenticatingRealm")
@Description(value="Xml Authenticating Realm")
public class XmlAuthenticatingRealm
extends AuthorizingRealm
implements Realm {
    private static final Logger logger = LoggerFactory.getLogger(XmlAuthenticatingRealm.class);
    public static final String ROLE = "XmlAuthenticatingRealm";
    private ConfigurationManager configuration;
    private PasswordService passwordService;
    private final int MAX_LEGACY_PASSWORD_LENGTH = 40;

    @Inject
    public XmlAuthenticatingRealm(@Named(value="default") ConfigurationManager configuration, PasswordService passwordService) {
        this.configuration = configuration;
        this.passwordService = passwordService;
        PasswordMatcher passwordMatcher = new PasswordMatcher();
        passwordMatcher.setPasswordService(this.passwordService);
        this.setCredentialsMatcher((CredentialsMatcher)passwordMatcher);
        this.setName(ROLE);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        CUser user;
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        try {
            user = this.configuration.readUser(upToken.getUsername());
        }
        catch (UserNotFoundException e) {
            throw new AccountException("User '" + upToken.getUsername() + "' cannot be retrieved.", (Throwable)e);
        }
        if (user.getPassword() == null) {
            throw new AccountException("User '" + upToken.getUsername() + "' has no password, cannot authenticate.");
        }
        if ("active".equals(user.getStatus())) {
            if (this.isLegacyUser(user) && this.isValidCredentials(upToken, user)) {
                this.reHashPassword(user, new String(upToken.getPassword()));
            }
            return this.createAuthenticationInfo(user);
        }
        if ("disabled".equals(user.getStatus())) {
            throw new DisabledAccountException("User '" + upToken.getUsername() + "' is disabled.");
        }
        throw new AccountException("User '" + upToken.getUsername() + "' is in illegal status '" + user.getStatus() + "'.");
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection arg0) {
        return null;
    }

    private void reHashPassword(final CUser user, final String password) {
        final String currentPasswordHash = user.getPassword();
        try {
            this.configuration.runWrite(new ConfigurationManagerAction(){

                @Override
                public void run() throws Exception {
                    try {
                        user.setPassword(XmlAuthenticatingRealm.this.passwordService.encryptPassword((Object)password));
                        XmlAuthenticatingRealm.this.configuration.updateUser(user);
                        XmlAuthenticatingRealm.this.configuration.save();
                    }
                    catch (Exception e) {
                        user.setPassword(currentPasswordHash);
                        logger.error("Unable to update hash for user {}", (Object)user.getId(), (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean isValidCredentials(UsernamePasswordToken token, CUser user) {
        boolean credentialsValid = false;
        AuthenticationInfo info = this.createAuthenticationInfo(user);
        CredentialsMatcher matcher = this.getCredentialsMatcher();
        if (matcher != null && matcher.doCredentialsMatch((AuthenticationToken)token, info)) {
            credentialsValid = true;
        }
        return credentialsValid;
    }

    private boolean isLegacyUser(CUser user) {
        return user.getPassword().length() <= this.MAX_LEGACY_PASSWORD_LENGTH;
    }

    private AuthenticationInfo createAuthenticationInfo(CUser user) {
        return new SimpleAuthenticationInfo((Object)user.getId(), (Object)user.getPassword().toCharArray(), this.getName());
    }
}

