/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.v2_0_4;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.security.model.v2_0_4.CPrivilege;
import org.sonatype.security.model.v2_0_4.CRole;
import org.sonatype.security.model.v2_0_4.CUser;
import org.sonatype.security.model.v2_0_4.CUserRoleMapping;

public class Configuration
implements org.sonatype.configuration.Configuration,
Serializable,
Cloneable {
    private String version;
    private List<CUser> users;
    private List<CRole> roles;
    private List<CPrivilege> privileges;
    private List<CUserRoleMapping> userRoleMappings;
    private String modelEncoding = "UTF-8";
    public static final String MODEL_VERSION = "2.0.4";

    public void addPrivilege(CPrivilege cPrivilege) {
        this.getPrivileges().add(cPrivilege);
    }

    public void addRole(CRole cRole) {
        this.getRoles().add(cRole);
    }

    public void addUser(CUser cUser) {
        this.getUsers().add(cUser);
    }

    public void addUserRoleMapping(CUserRoleMapping cUserRoleMapping) {
        this.getUserRoleMappings().add(cUserRoleMapping);
    }

    public Configuration clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            if (this.users != null) {
                copy.users = new ArrayList<CUser>();
                for (CUser cUser : this.users) {
                    copy.users.add(cUser.clone());
                }
            }
            if (this.roles != null) {
                copy.roles = new ArrayList<CRole>();
                for (CRole cRole : this.roles) {
                    copy.roles.add(cRole.clone());
                }
            }
            if (this.privileges != null) {
                copy.privileges = new ArrayList<CPrivilege>();
                for (CPrivilege cPrivilege : this.privileges) {
                    copy.privileges.add(cPrivilege.clone());
                }
            }
            if (this.userRoleMappings != null) {
                copy.userRoleMappings = new ArrayList<CUserRoleMapping>();
                for (CUserRoleMapping cUserRoleMapping : this.userRoleMappings) {
                    copy.userRoleMappings.add(cUserRoleMapping.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<CPrivilege> getPrivileges() {
        if (this.privileges == null) {
            this.privileges = new ArrayList<CPrivilege>();
        }
        return this.privileges;
    }

    public List<CRole> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<CRole>();
        }
        return this.roles;
    }

    public List<CUserRoleMapping> getUserRoleMappings() {
        if (this.userRoleMappings == null) {
            this.userRoleMappings = new ArrayList<CUserRoleMapping>();
        }
        return this.userRoleMappings;
    }

    public List<CUser> getUsers() {
        if (this.users == null) {
            this.users = new ArrayList<CUser>();
        }
        return this.users;
    }

    public String getVersion() {
        return this.version;
    }

    public void removePrivilege(CPrivilege cPrivilege) {
        this.getPrivileges().remove(cPrivilege);
    }

    public void removeRole(CRole cRole) {
        this.getRoles().remove(cRole);
    }

    public void removeUser(CUser cUser) {
        this.getUsers().remove(cUser);
    }

    public void removeUserRoleMapping(CUserRoleMapping cUserRoleMapping) {
        this.getUserRoleMappings().remove(cUserRoleMapping);
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setPrivileges(List<CPrivilege> privileges) {
        this.privileges = privileges;
    }

    public void setRoles(List<CRole> roles) {
        this.roles = roles;
    }

    public void setUserRoleMappings(List<CUserRoleMapping> userRoleMappings) {
        this.userRoleMappings = userRoleMappings;
    }

    public void setUsers(List<CUser> users) {
        this.users = users;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

