/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.v2_0_3.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.sonatype.security.model.v2_0_3.CPrivilege;
import org.sonatype.security.model.v2_0_3.CProperty;
import org.sonatype.security.model.v2_0_3.CRole;
import org.sonatype.security.model.v2_0_3.CUser;
import org.sonatype.security.model.v2_0_3.CUserRoleMapping;
import org.sonatype.security.model.v2_0_3.Configuration;

public class SecurityConfigurationXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "security", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, configuration.getModelEncoding());
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "security", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeCPrivilege(CPrivilege cPrivilege, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cPrivilege.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cPrivilege.getId()).endTag(NAMESPACE, "id");
        }
        if (cPrivilege.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cPrivilege.getName()).endTag(NAMESPACE, "name");
        }
        if (cPrivilege.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(cPrivilege.getDescription()).endTag(NAMESPACE, "description");
        }
        if (cPrivilege.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(cPrivilege.getType()).endTag(NAMESPACE, "type");
        }
        if (cPrivilege.getProperties() != null && cPrivilege.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            for (CProperty o : cPrivilege.getProperties()) {
                this.writeCProperty(o, "property", serializer);
            }
            serializer.endTag(NAMESPACE, "properties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCProperty(CProperty cProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cProperty.getKey() != null) {
            serializer.startTag(NAMESPACE, "key").text(cProperty.getKey()).endTag(NAMESPACE, "key");
        }
        if (cProperty.getValue() != null) {
            serializer.startTag(NAMESPACE, "value").text(cProperty.getValue()).endTag(NAMESPACE, "value");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRole(CRole cRole, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRole.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cRole.getId()).endTag(NAMESPACE, "id");
        }
        if (cRole.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cRole.getName()).endTag(NAMESPACE, "name");
        }
        if (cRole.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(cRole.getDescription()).endTag(NAMESPACE, "description");
        }
        if (cRole.getSessionTimeout() != 0) {
            serializer.startTag(NAMESPACE, "sessionTimeout").text(String.valueOf(cRole.getSessionTimeout())).endTag(NAMESPACE, "sessionTimeout");
        }
        if (cRole.getPrivileges() != null && cRole.getPrivileges().size() > 0) {
            serializer.startTag(NAMESPACE, "privileges");
            for (String privilege : cRole.getPrivileges()) {
                serializer.startTag(NAMESPACE, "privilege").text(privilege).endTag(NAMESPACE, "privilege");
            }
            serializer.endTag(NAMESPACE, "privileges");
        }
        if (cRole.getRoles() != null && cRole.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "roles");
            for (String role : cRole.getRoles()) {
                serializer.startTag(NAMESPACE, "role").text(role).endTag(NAMESPACE, "role");
            }
            serializer.endTag(NAMESPACE, "roles");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCUser(CUser cUser, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cUser.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cUser.getId()).endTag(NAMESPACE, "id");
        }
        if (cUser.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cUser.getName()).endTag(NAMESPACE, "name");
        }
        if (cUser.getPassword() != null) {
            serializer.startTag(NAMESPACE, "password").text(cUser.getPassword()).endTag(NAMESPACE, "password");
        }
        if (cUser.getStatus() != null) {
            serializer.startTag(NAMESPACE, "status").text(cUser.getStatus()).endTag(NAMESPACE, "status");
        }
        if (cUser.getEmail() != null) {
            serializer.startTag(NAMESPACE, "email").text(cUser.getEmail()).endTag(NAMESPACE, "email");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCUserRoleMapping(CUserRoleMapping cUserRoleMapping, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cUserRoleMapping.getUserId() != null) {
            serializer.startTag(NAMESPACE, "userId").text(cUserRoleMapping.getUserId()).endTag(NAMESPACE, "userId");
        }
        if (cUserRoleMapping.getSource() != null) {
            serializer.startTag(NAMESPACE, "source").text(cUserRoleMapping.getSource()).endTag(NAMESPACE, "source");
        }
        if (cUserRoleMapping.getRoles() != null && cUserRoleMapping.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "roles");
            for (String role : cUserRoleMapping.getRoles()) {
                serializer.startTag(NAMESPACE, "role").text(role).endTag(NAMESPACE, "role");
            }
            serializer.endTag(NAMESPACE, "roles");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeConfiguration(Configuration configuration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (configuration.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(configuration.getVersion()).endTag(NAMESPACE, "version");
        }
        if (configuration.getUsers() != null && configuration.getUsers().size() > 0) {
            serializer.startTag(NAMESPACE, "users");
            for (CUser cUser : configuration.getUsers()) {
                this.writeCUser(cUser, "user", serializer);
            }
            serializer.endTag(NAMESPACE, "users");
        }
        if (configuration.getRoles() != null && configuration.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "roles");
            for (CRole cRole : configuration.getRoles()) {
                this.writeCRole(cRole, "role", serializer);
            }
            serializer.endTag(NAMESPACE, "roles");
        }
        if (configuration.getPrivileges() != null && configuration.getPrivileges().size() > 0) {
            serializer.startTag(NAMESPACE, "privileges");
            for (CPrivilege cPrivilege : configuration.getPrivileges()) {
                this.writeCPrivilege(cPrivilege, "privilege", serializer);
            }
            serializer.endTag(NAMESPACE, "privileges");
        }
        if (configuration.getUserRoleMappings() != null && configuration.getUserRoleMappings().size() > 0) {
            serializer.startTag(NAMESPACE, "userRoleMappings");
            for (CUserRoleMapping cUserRoleMapping : configuration.getUserRoleMappings()) {
                this.writeCUserRoleMapping(cUserRoleMapping, "userRoleMapping", serializer);
            }
            serializer.endTag(NAMESPACE, "userRoleMappings");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

