/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.v2_0_0;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.security.model.v2_0_0.CProperty;

public class CPrivilege
implements Serializable,
Cloneable {
    private String id;
    private String name;
    private String description;
    private String type;
    private List<CProperty> properties;

    public void addProperty(CProperty cProperty) {
        this.getProperties().add(cProperty);
    }

    public CPrivilege clone() {
        try {
            CPrivilege copy = (CPrivilege)super.clone();
            if (this.properties != null) {
                copy.properties = new ArrayList<CProperty>();
                for (CProperty item : this.properties) {
                    copy.properties.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<CProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<CProperty>();
        }
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public void removeProperty(CProperty cProperty) {
        this.getProperties().remove(cProperty);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(List<CProperty> properties) {
        this.properties = properties;
    }

    public void setType(String type) {
        this.type = type;
    }
}

