/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.upgrade.SecurityUpgrader;
import org.sonatype.security.model.v2_0_4.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.model.v2_0_5.upgrade.BasicVersionUpgrade;

@Singleton
@Typed(value={SecurityUpgrader.class})
@Named(value="2.0.4")
public class Upgrade204to205
implements SecurityUpgrader {
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (FileReader fr = null;){
            fr = new FileReader(file);
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            org.sonatype.security.model.v2_0_4.Configuration configuration = reader.read(fr);
            return configuration;
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        org.sonatype.security.model.v2_0_4.Configuration oldc = (org.sonatype.security.model.v2_0_4.Configuration)message.getConfiguration();
        Configuration newc = new BasicVersionUpgrade().upgradeConfiguration(oldc);
        newc.setVersion("2.0.5");
        message.setModelVersion("2.0.5");
        message.setConfiguration((Object)newc);
    }
}

