/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.model.upgrade.SecurityUpgrader;
import org.sonatype.security.model.v2_0_3.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.model.v2_0_4.CUser;
import org.sonatype.security.model.v2_0_4.Configuration;
import org.sonatype.security.model.v2_0_4.upgrade.BasicVersionUpgrade;

@Singleton
@Typed(value={SecurityUpgrader.class})
@Named(value="2.0.3")
public class Upgrade203to204
implements SecurityUpgrader {
    private static String DEFAULT_SOURCE = "default";

    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (FileReader fr = null;){
            fr = new FileReader(file);
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            org.sonatype.security.model.v2_0_3.Configuration configuration = reader.read(fr);
            return configuration;
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        org.sonatype.security.model.v2_0_3.Configuration oldc = (org.sonatype.security.model.v2_0_3.Configuration)message.getConfiguration();
        Configuration newc = new SecurityVersionUpgrade().upgradeConfiguration(oldc);
        newc.setVersion("2.0.4");
        message.setModelVersion("2.0.4");
        message.setConfiguration((Object)newc);
    }

    class SecurityVersionUpgrade
    extends BasicVersionUpgrade {
        SecurityVersionUpgrade() {
        }

        @Override
        public CUser upgradeCUser(org.sonatype.security.model.v2_0_3.CUser cUser, CUser value) {
            CUser upgradedUser = super.upgradeCUser(cUser, value);
            String name = cUser.getName();
            String[] nameParts = name.trim().split(" ", 2);
            upgradedUser.setFirstName(nameParts[0]);
            if (nameParts.length > 1) {
                upgradedUser.setLastName(nameParts[1]);
            }
            return upgradedUser;
        }
    }
}

