/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.model.upgrade.SecurityUpgrader;
import org.sonatype.security.model.v2_0_2.Configuration;
import org.sonatype.security.model.v2_0_2.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.model.v2_0_3.CUser;
import org.sonatype.security.model.v2_0_3.CUserRoleMapping;
import org.sonatype.security.model.v2_0_3.upgrade.BasicVersionUpgrade;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={SecurityUpgrader.class})
@Named(value="2.0.2")
public class Upgrade202to203
extends ComponentSupport
implements SecurityUpgrader {
    private static String DEFAULT_SOURCE = "default";

    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (FileReader fr = null;){
            fr = new FileReader(file);
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            Configuration configuration = reader.read(fr);
            return configuration;
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        Configuration oldc = (Configuration)message.getConfiguration();
        org.sonatype.security.model.v2_0_3.Configuration newc = new BasicVersionUpgrade().upgradeConfiguration(oldc);
        Iterator<CUserRoleMapping> iter = newc.getUserRoleMappings().iterator();
        while (iter.hasNext()) {
            CUserRoleMapping roleMapping = iter.next();
            if (!DEFAULT_SOURCE.equalsIgnoreCase(roleMapping.getSource()) || this.hasUser(roleMapping.getUserId(), newc)) continue;
            this.log.info("Removing orphaned user role mapping for user: '" + roleMapping.getUserId() + "'.");
            iter.remove();
        }
        newc.setVersion("2.0.3");
        message.setModelVersion("2.0.3");
        message.setConfiguration((Object)newc);
    }

    private boolean hasUser(String userId, org.sonatype.security.model.v2_0_3.Configuration configuration) {
        for (CUser user : configuration.getUsers()) {
            if (!user.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }
}

