/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.model.upgrade.SecurityUpgrader;
import org.sonatype.security.model.v2_0_1.CPrivilege;
import org.sonatype.security.model.v2_0_1.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.model.v2_0_2.CProperty;
import org.sonatype.security.model.v2_0_2.CRole;
import org.sonatype.security.model.v2_0_2.CUser;
import org.sonatype.security.model.v2_0_2.CUserRoleMapping;
import org.sonatype.security.model.v2_0_2.Configuration;

@Singleton
@Typed(value={SecurityUpgrader.class})
@Named(value="2.0.1")
public class Upgrade201to202
implements SecurityUpgrader {
    private static String DEFAULT_SOURCE = "default";

    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (FileReader fr = null;){
            fr = new FileReader(file);
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            org.sonatype.security.model.v2_0_1.Configuration configuration = reader.read(fr);
            return configuration;
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        org.sonatype.security.model.v2_0_1.Configuration oldc = (org.sonatype.security.model.v2_0_1.Configuration)message.getConfiguration();
        Configuration newc = new Configuration();
        newc.setVersion("2.0.5");
        for (org.sonatype.security.model.v2_0_1.CUser oldu : oldc.getUsers()) {
            CUser newu = new CUser();
            newu.setEmail(oldu.getEmail());
            newu.setId(oldu.getId());
            newu.setName(oldu.getName());
            newu.setPassword(oldu.getPassword());
            newu.setStatus(oldu.getStatus());
            this.migrateOldRolesToUserRoleMapping(oldu.getId(), DEFAULT_SOURCE, oldu.getRoles(), newc);
            newc.addUser(newu);
        }
        HashMap roleIdMap = new HashMap();
        for (org.sonatype.security.model.v2_0_1.CRole oldr : oldc.getRoles()) {
            CRole newr = new CRole();
            newr.setDescription(oldr.getDescription());
            newr.setId(oldr.getId());
            newr.setName(oldr.getName());
            newr.setPrivileges(oldr.getPrivileges());
            newr.setRoles(oldr.getRoles());
            newr.setSessionTimeout(oldr.getSessionTimeout());
            newc.addRole(newr);
        }
        for (CPrivilege oldp : oldc.getPrivileges()) {
            org.sonatype.security.model.v2_0_2.CPrivilege newp = new org.sonatype.security.model.v2_0_2.CPrivilege();
            newp.setDescription(oldp.getDescription());
            newp.setId(oldp.getId());
            newp.setName(oldp.getName());
            newp.setType(oldp.getType());
            for (org.sonatype.security.model.v2_0_1.CProperty oldprop : oldp.getProperties()) {
                CProperty newprop = new CProperty();
                newprop.setKey(oldprop.getKey());
                newprop.setValue(oldprop.getValue());
                newp.addProperty(newprop);
            }
            newc.addPrivilege(newp);
        }
        message.setModelVersion("2.0.2");
        message.setConfiguration((Object)newc);
    }

    private void migrateOldRolesToUserRoleMapping(String userId, String source, List<String> roles, Configuration config) {
        CUserRoleMapping roleMapping = new CUserRoleMapping();
        roleMapping.setRoles(roles);
        roleMapping.setSource(source);
        roleMapping.setUserId(userId);
        config.addUserRoleMapping(roleMapping);
    }
}

