/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.legacy.model.v1_0_0.CApplicationPrivilege;
import org.sonatype.security.legacy.model.v1_0_0.CRepoTargetPrivilege;
import org.sonatype.security.legacy.model.v1_0_0.CRole;
import org.sonatype.security.legacy.model.v1_0_0.Configuration;
import org.sonatype.security.legacy.model.v1_0_0.io.xpp3.SecurityLegacyConfigurationXpp3Reader;
import org.sonatype.security.model.upgrade.SecurityUpgrader;
import org.sonatype.security.model.v2_0_0.CPrivilege;
import org.sonatype.security.model.v2_0_0.CProperty;
import org.sonatype.security.model.v2_0_0.CUser;

@Singleton
@Typed(value={SecurityUpgrader.class})
@Named(value="1.0.0")
public class Upgrade100to200
implements SecurityUpgrader {
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (FileReader fr = null;){
            fr = new FileReader(file);
            SecurityLegacyConfigurationXpp3Reader reader = new SecurityLegacyConfigurationXpp3Reader();
            Configuration configuration = reader.read(fr);
            return configuration;
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        CProperty prop;
        CPrivilege newp;
        Configuration oldc = (Configuration)message.getConfiguration();
        org.sonatype.security.model.v2_0_0.Configuration newc = new org.sonatype.security.model.v2_0_0.Configuration();
        newc.setVersion("2.0.0");
        for (org.sonatype.security.legacy.model.v1_0_0.CUser cUser : oldc.getUsers()) {
            CUser newu = new CUser();
            newu.setEmail(cUser.getEmail());
            newu.setId(cUser.getUserId());
            newu.setName(cUser.getName());
            newu.setPassword(cUser.getPassword());
            newu.setStatus(cUser.getStatus());
            newu.setRoles(cUser.getRoles());
            newc.addUser(newu);
        }
        for (CRole cRole : oldc.getRoles()) {
            org.sonatype.security.model.v2_0_0.CRole newr = new org.sonatype.security.model.v2_0_0.CRole();
            newr.setDescription(cRole.getDescription());
            newr.setId(cRole.getId());
            newr.setName(cRole.getName());
            newr.setPrivileges(cRole.getPrivileges());
            newr.setRoles(cRole.getRoles());
            newr.setSessionTimeout(cRole.getSessionTimeout());
            newc.addRole(newr);
        }
        for (CRepoTargetPrivilege cRepoTargetPrivilege : oldc.getRepositoryTargetPrivileges()) {
            newp = new CPrivilege();
            newp.setDescription(cRepoTargetPrivilege.getDescription());
            newp.setId(cRepoTargetPrivilege.getId());
            newp.setName(cRepoTargetPrivilege.getName());
            newp.setType("target");
            prop = new CProperty();
            prop.setKey("method");
            prop.setValue(cRepoTargetPrivilege.getMethod());
            newp.addProperty(prop);
            if (!StringUtils.isEmpty((String)cRepoTargetPrivilege.getRepositoryId())) {
                prop = new CProperty();
                prop.setKey("repositoryGroupId");
                prop.setValue(cRepoTargetPrivilege.getGroupId());
                newp.addProperty(prop);
            }
            if (!StringUtils.isEmpty((String)cRepoTargetPrivilege.getRepositoryId())) {
                prop = new CProperty();
                prop.setKey("repositoryId");
                prop.setValue(cRepoTargetPrivilege.getRepositoryId());
                newp.addProperty(prop);
            }
            prop = new CProperty();
            prop.setKey("repositoryTargetId");
            prop.setValue(cRepoTargetPrivilege.getRepositoryTargetId());
            newp.addProperty(prop);
            newc.addPrivilege(newp);
        }
        for (CApplicationPrivilege cApplicationPrivilege : oldc.getApplicationPrivileges()) {
            newp = new CPrivilege();
            newp.setDescription(cApplicationPrivilege.getDescription());
            newp.setId(cApplicationPrivilege.getId());
            newp.setName(cApplicationPrivilege.getName());
            newp.setType("method");
            prop = new CProperty();
            prop.setKey("method");
            prop.setValue(cApplicationPrivilege.getMethod());
            newp.addProperty(prop);
            prop = new CProperty();
            prop.setKey("permission");
            prop.setValue(cApplicationPrivilege.getPermission());
            newp.addProperty(prop);
            newc.addPrivilege(newp);
        }
        message.setModelVersion("2.0.0");
        message.setConfiguration((Object)newc);
    }
}

