/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UnsupportedConfigurationVersionException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.upgrade.SecurityConfigurationUpgrader;
import org.sonatype.security.model.upgrade.SecurityDataUpgrader;
import org.sonatype.security.model.upgrade.SecurityUpgrader;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={SecurityConfigurationUpgrader.class})
@Named(value="default")
public class DefaultSecurityConfigurationUpgrader
extends ComponentSupport
implements SecurityConfigurationUpgrader {
    private final Map<String, SecurityUpgrader> upgraders;
    private final Map<String, SecurityDataUpgrader> dataUpgraders;

    @Inject
    public DefaultSecurityConfigurationUpgrader(Map<String, SecurityUpgrader> upgraders, Map<String, SecurityDataUpgrader> dataUpgraders) {
        this.upgraders = upgraders;
        this.dataUpgraders = dataUpgraders;
    }

    public Configuration loadOldConfiguration(File file) throws IOException, ConfigurationIsCorruptedException, UnsupportedConfigurationVersionException {
        String modelVersion = null;
        try {
            BufferedReader r = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)file));
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)r);
            modelVersion = dom.getChild("version").getValue();
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
        if ("2.0.5".equals(modelVersion)) {
            throw new ConfigurationIsCorruptedException(file);
        }
        UpgradeMessage msg = new UpgradeMessage();
        msg.setModelVersion(modelVersion);
        SecurityUpgrader upgrader = this.upgraders.get(msg.getModelVersion());
        if (upgrader != null) {
            this.log.info("Upgrading old Security configuration file (version " + msg.getModelVersion() + ") from " + file.getAbsolutePath());
            msg.setConfiguration(upgrader.loadConfiguration(file));
            while (!"2.0.5".equals(msg.getModelVersion())) {
                SecurityDataUpgrader dataUpgrader = this.dataUpgraders.get(msg.getModelVersion());
                if (upgrader != null) {
                    upgrader.upgrade(msg);
                    if (dataUpgrader != null) {
                        dataUpgrader.upgrade(msg.getConfiguration());
                    }
                } else {
                    throw new UnsupportedConfigurationVersionException(modelVersion, file);
                }
                upgrader = this.upgraders.get(msg.getModelVersion());
            }
            this.log.info("Security configuration file upgraded to current version " + msg.getModelVersion() + " succesfully.");
            return (Configuration)msg.getConfiguration();
        }
        throw new UnsupportedConfigurationVersionException(modelVersion, file);
    }
}

