/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.source;

import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.source.AbstractSecurityModelConfigurationSource;
import org.sonatype.security.model.source.SecurityModelConfigurationSource;

@Singleton
@Typed(value={SecurityModelConfigurationSource.class})
@Named(value="static")
public class StaticModelConfigurationSource
extends AbstractSecurityModelConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(StaticModelConfigurationSource.class);
    private static final String STATIC_SECURITY_RESOURCE = "/META-INF/security/security.xml";

    @Override
    public InputStream getConfigurationAsStream() throws IOException {
        return this.getClass().getResourceAsStream(STATIC_SECURITY_RESOURCE);
    }

    public Configuration loadConfiguration() throws ConfigurationException, IOException {
        if (this.getClass().getResource(STATIC_SECURITY_RESOURCE) != null) {
            this.loadConfiguration(this.getConfigurationAsStream());
        } else {
            log.warn("Default static security configuration not found in classpath: /META-INF/security/security.xml");
        }
        Configuration configuration = this.getConfiguration();
        return configuration;
    }

    public void storeConfiguration() throws IOException {
        throw new UnsupportedOperationException("The SecurityDefaultsConfigurationSource is static source!");
    }

    public boolean isConfigurationDefaulted() {
        return false;
    }

    @Override
    public void backupConfiguration() throws IOException {
        throw new UnsupportedOperationException("The SecurityDefaultsConfigurationSource is a read only source!");
    }
}

