/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.source;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.io.xpp3.SecurityConfigurationXpp3Writer;
import org.sonatype.security.model.source.AbstractSecurityModelConfigurationSource;
import org.sonatype.security.model.source.SecurityModelConfigurationSource;
import org.sonatype.security.model.upgrade.SecurityConfigurationUpgrader;
import org.sonatype.sisu.goodies.common.io.FileReplacer;

@Singleton
@Typed(value={SecurityModelConfigurationSource.class})
@Named(value="file")
public class FileModelConfigurationSource
extends AbstractSecurityModelConfigurationSource {
    private final File configurationFile;
    private final SecurityConfigurationUpgrader configurationUpgrader;
    private final SecurityModelConfigurationSource securityDefaults;
    private boolean configurationDefaulted;

    @Inject
    public FileModelConfigurationSource(@Named(value="${security-xml-file}") File configurationFile, @Named(value="static") SecurityModelConfigurationSource securityDefaults, SecurityConfigurationUpgrader configurationUpgrader) {
        this.configurationFile = configurationFile;
        this.securityDefaults = securityDefaults;
        this.configurationUpgrader = configurationUpgrader;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public Configuration loadConfiguration() throws ConfigurationException, IOException {
        this.securityDefaults.loadConfiguration();
        if (this.getConfigurationFile() == null || this.getConfigurationFile().getAbsolutePath().contains("${")) {
            throw new ConfigurationException("The configuration file is not set or resolved properly: " + (this.getConfigurationFile() == null ? "null" : this.getConfigurationFile().getAbsolutePath()));
        }
        if (!this.getConfigurationFile().exists()) {
            this.getLogger().warn("No configuration file in place, copying the default one and continuing with it.");
            this.setConfiguration((Configuration)this.securityDefaults.getConfiguration());
            if (this.getConfiguration() == null) {
                Configuration configuration = new Configuration();
                configuration.setVersion("2.0.5");
                this.setConfiguration(configuration);
            }
            this.saveConfiguration(this.getConfigurationFile());
            this.configurationDefaulted = true;
        } else {
            this.configurationDefaulted = false;
        }
        this.loadConfiguration(this.getConfigurationFile());
        if (this.getConfiguration() == null) {
            this.upgradeConfiguration(this.getConfigurationFile());
            this.loadConfiguration(this.getConfigurationFile());
        }
        return this.getConfiguration();
    }

    public void storeConfiguration() throws IOException {
        this.saveConfiguration(this.getConfigurationFile());
    }

    @Override
    public InputStream getConfigurationAsStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getConfigurationFile()));
    }

    @Override
    public SecurityModelConfigurationSource getDefaultsSource() {
        return this.securityDefaults;
    }

    protected void upgradeConfiguration(File file) throws IOException, ConfigurationException {
        this.getLogger().info("Trying to upgrade the configuration file " + file.getAbsolutePath());
        this.setConfiguration((Configuration)this.configurationUpgrader.loadOldConfiguration(file));
        if (this.getConfiguration() == null) {
            throw new ConfigurationException("Could not upgrade Security configuration! Please replace the " + file.getAbsolutePath() + " file with a valid Security configuration file.");
        }
        this.getLogger().info("Creating backup from the old file and saving the upgraded configuration.");
        this.backupConfiguration();
        this.setConfigurationUpgraded(true);
        this.saveConfiguration(file);
    }

    private void loadConfiguration(File file) throws IOException {
        this.getLogger().info("Loading security configuration from: " + file.getAbsolutePath());
        try (InputStream input = null;){
            input = new BufferedInputStream(new FileInputStream(file));
            this.loadConfiguration(input);
        }
    }

    private static void mkdir(Path dir) throws IOException {
        block2: {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(dir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    private void saveConfiguration(File file) throws IOException {
        try {
            FileModelConfigurationSource.mkdir(file.getParentFile().toPath());
        }
        catch (IOException e) {
            String message = "\r\n******************************************************************************\r\n* Could not create configuration file [ " + file.toString() + "]!!!! *\r\n" + "* Application cannot start properly until the process has read+write permissions to this folder *\r\n" + "******************************************************************************";
            this.getLogger().error(message);
            throw new IOException("Could not create configuration file " + file.getAbsolutePath(), e);
        }
        final Configuration configuration = this.getConfiguration();
        Preconditions.checkNotNull((Object)configuration, (Object)"Missing security configuration");
        this.getLogger().debug("Saving configuration: {}", (Object)file);
        FileReplacer fileReplacer = new FileReplacer(file);
        fileReplacer.setDeleteBackupFile(true);
        fileReplacer.replace(new FileReplacer.ContentWriter(){

            public void write(BufferedOutputStream output) throws IOException {
                new SecurityConfigurationXpp3Writer().write(output, configuration);
            }
        });
    }

    public boolean isConfigurationDefaulted() {
        return this.configurationDefaulted;
    }

    @Override
    public void backupConfiguration() throws IOException {
        File file = this.getConfigurationFile();
        File backup = new File(file.getParentFile(), file.getName() + ".bak");
        FileUtils.copyFile((File)file, (File)backup);
    }
}

