/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.model.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.sonatype.configuration.source.AbstractStreamConfigurationSource;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.model.source.SecurityModelConfigurationSource;

public abstract class AbstractSecurityModelConfigurationSource
extends AbstractStreamConfigurationSource<Configuration>
implements SecurityModelConfigurationSource {
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void rejectConfiguration(String message) {
        this.configuration = null;
        if (message != null) {
            this.getLogger().warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfiguration(InputStream is) throws IOException {
        this.setConfigurationUpgraded(false);
        try (Reader fr = null;){
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            fr = new InputStreamReader(is);
            this.configuration = reader.read(fr);
        }
        if (this.configuration != null && !"2.0.5".equals(this.configuration.getVersion())) {
            this.rejectConfiguration("Security configuration file was loaded but discarded, it has the wrong version number.");
        }
        if (this.getConfiguration() != null) {
            this.getLogger().debug("Configuration loaded succesfully.");
        }
    }

    public SecurityModelConfigurationSource getDefaultsSource() {
        return null;
    }
}

