/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.anon;

import java.util.Random;

class StringSequence {
    private static final char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '@', '+', '*', '~', '#', '-', '_', '$'};
    private char[] salt;
    private int[] digits;
    private int size;

    public StringSequence(int saltSize) {
        this.salt = new char[saltSize];
        this.digits = new int[64];
        this.size = 1;
        Random rnd = new Random();
        for (int i = 0; i < this.salt.length; ++i) {
            this.salt[i] = ALPHABET[rnd.nextInt(ALPHABET.length)];
        }
    }

    public String next() {
        int i;
        char[] chars = new char[this.size + this.salt.length];
        for (i = 0; i < this.size; ++i) {
            chars[this.size - i - 1] = ALPHABET[this.digits[i]];
        }
        for (i = 0; i < this.salt.length; ++i) {
            chars[i + this.size] = this.salt[i];
        }
        this.increment();
        return new String(chars);
    }

    private void increment() {
        int i = 0;
        while (true) {
            if (i >= this.size) {
                this.size = i + 1;
                break;
            }
            this.digits[i] = (this.digits[i] + 1) % ALPHABET.length;
            if (this.digits[i] > 0) break;
            if (i + 1 >= this.digits.length) {
                int[] tmp = new int[this.digits.length + 16];
                System.arraycopy(this.digits, 0, tmp, 0, this.digits.length);
                this.digits = tmp;
            }
            ++i;
        }
    }
}

