/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.anon;

import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.anon.StringSequence;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.util.HashUtils;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;

@Named
public class DefaultAnonymizer
implements Anonymizer {
    private static final String DIGESTER = "SHA-1";
    private static final String STRING_SEQUENCE = "stringSequence";
    private static final String STRING_SEQUENCE_SALT = "stringSequenceSalt";
    private static final String EXISTING_MAPPINGS = "existingMappings";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(String value, ReverseLookupTable table) {
        if (value == null || value.length() <= 0) {
            return value;
        }
        String anon = HashUtils.hash(value, DIGESTER);
        if (table != null) {
            ReverseLookupTable reverseLookupTable = table;
            synchronized (reverseLookupTable) {
                table.addAnonymization(anon, value);
            }
        }
        return anon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String anonymize(String value, ReverseLookupTable table) {
        if (table == null || value == null || value.length() <= 0) {
            return value;
        }
        ReverseLookupTable reverseLookupTable = table;
        synchronized (reverseLookupTable) {
            String anon;
            HashMap<String, String> mappings;
            StringSequence sequence = (StringSequence)table.getWorkData((Object)STRING_SEQUENCE, StringSequence.class);
            if (sequence == null) {
                Integer saltSize = (Integer)table.getWorkData((Object)STRING_SEQUENCE_SALT, Integer.class);
                sequence = new StringSequence(saltSize != null ? saltSize : 0);
                table.setWorkData((Object)STRING_SEQUENCE, (Object)sequence);
            }
            if ((mappings = (HashMap<String, String>)table.getWorkData((Object)EXISTING_MAPPINGS, Map.class)) == null) {
                mappings = new HashMap<String, String>(1024);
                table.setWorkData((Object)EXISTING_MAPPINGS, mappings);
            }
            if ((anon = (String)mappings.get(value)) == null) {
                anon = sequence.next();
                mappings.put(value, anon);
                table.addAnonymization(anon, value);
            }
            return anon;
        }
    }

    @Override
    public String anonymizePath(String path, ReverseLookupTable table) {
        if (table == null || path == null) {
            return path;
        }
        StringBuilder buffer = new StringBuilder(256);
        String[] parts = path.split("\\/", -1);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                buffer.append('/');
            }
            buffer.append(this.anonymize(parts[i], table));
        }
        return buffer.toString();
    }

    @Override
    public String anonymizeArtifactId(String id, ReverseLookupTable table) {
        if (id == null) {
            return id;
        }
        StringBuilder buffer = new StringBuilder(256);
        String[] parts = ArtifactId.split((String)id);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                buffer.append(':');
            }
            buffer.append(this.hash(parts[i], table));
        }
        return buffer.toString();
    }

    @Override
    public String restore(String value, ReverseLookupTable table) {
        if (table == null || value == null || value.length() <= 0) {
            return value;
        }
        String original = table.lookupAnonymization(value);
        return original != null ? original : value;
    }

    @Override
    public String restorePath(String path, ReverseLookupTable table) {
        if (table == null || path == null) {
            return path;
        }
        StringBuilder buffer = new StringBuilder(256);
        String[] parts = path.split("\\/", -1);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                buffer.append('/');
            }
            buffer.append(this.restore(parts[i], table));
        }
        return buffer.toString();
    }

    @Override
    public String restoreArtifactId(String id, ReverseLookupTable table) {
        if (table == null || id == null) {
            return id;
        }
        StringBuilder buffer = new StringBuilder(256);
        String[] parts = ArtifactId.split((String)id);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                buffer.append(':');
            }
            buffer.append(this.restore(parts[i], table));
        }
        return buffer.toString();
    }
}

